/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.collect.Iterables;
import com.sap.ai.sdk.core.AiCoreService;
import com.sap.ai.sdk.core.JacksonConfiguration;
import com.sap.ai.sdk.prompt.registry.client.PromptTemplatesApi;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplate;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplateSpecResponseFormat;
import com.sap.ai.sdk.prompt.registry.model.ResponseFormatText;
import com.sap.ai.sdk.prompt.registry.model.SingleChatTemplate;
import com.sap.cloud.sdk.cloudplatform.connectivity.ApacheHttpClient5Accessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.services.openapi.apiclient.ApiClient;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.springframework.http.client.BufferingClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class PromptClient
extends PromptTemplatesApi {
    public PromptClient() {
        this(new AiCoreService());
    }

    public PromptClient(@Nonnull AiCoreService aiCoreService) {
        super(PromptClient.addMixin(aiCoreService));
    }

    @Nonnull
    private static ApiClient addMixin(@Nonnull AiCoreService service) {
        HttpDestination destination = service.getBaseDestination();
        HttpComponentsClientHttpRequestFactory httpRequestFactory = new HttpComponentsClientHttpRequestFactory();
        httpRequestFactory.setHttpClient(ApacheHttpClient5Accessor.getHttpClient((HttpDestinationProperties)destination));
        RestTemplate rt = new RestTemplate();
        Iterables.filter((Iterable)rt.getMessageConverters(), MappingJackson2HttpMessageConverter.class).forEach(converter -> converter.setObjectMapper(JacksonConfiguration.getDefaultObjectMapper().addMixIn(PromptTemplate.class, JacksonMixin.TemplateMixIn.class).addMixIn(PromptTemplateSpecResponseFormat.class, JacksonMixin.ResponseFormat.class)));
        rt.setRequestFactory((ClientHttpRequestFactory)new BufferingClientHttpRequestFactory((ClientHttpRequestFactory)httpRequestFactory));
        return new ApiClient(rt).setBasePath(destination.asHttp().getUri().toString());
    }

    private static class JacksonMixin {
        @Generated
        private JacksonMixin() {
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
        @JsonDeserialize(as=ResponseFormatText.class)
        static interface ResponseFormat {
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
        @JsonDeserialize(as=SingleChatTemplate.class)
        static interface TemplateMixIn {
        }
    }
}

