/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.client;

import com.google.common.annotations.Beta;
import com.sap.ai.sdk.prompt.registry.model.OrchestrationConfigDeleteResponse;
import com.sap.ai.sdk.prompt.registry.model.OrchestrationConfigGetResponse;
import com.sap.ai.sdk.prompt.registry.model.OrchestrationConfigListResponse;
import com.sap.ai.sdk.prompt.registry.model.OrchestrationConfigPostRequest;
import com.sap.ai.sdk.prompt.registry.model.OrchestrationConfigPostResponse;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.services.openapi.apiclient.ApiClient;
import com.sap.cloud.sdk.services.openapi.core.AbstractOpenApiService;
import com.sap.cloud.sdk.services.openapi.core.OpenApiRequestException;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class OrchestrationConfigsApi
extends AbstractOpenApiService {
    public OrchestrationConfigsApi(@Nonnull Destination httpDestination) {
        super(httpDestination);
    }

    @Beta
    public OrchestrationConfigsApi(@Nonnull ApiClient apiClient) {
        super(apiClient);
    }

    @Nonnull
    public OrchestrationConfigPostResponse createUpdateOrchestrationConfig(@Nonnull OrchestrationConfigPostRequest orchestrationConfigPostRequest, @Nullable String aiResourceGroup) throws OpenApiRequestException {
        OrchestrationConfigPostRequest localVarPostBody = orchestrationConfigPostRequest;
        if (orchestrationConfigPostRequest == null) {
            throw new OpenApiRequestException("Missing the required parameter 'orchestrationConfigPostRequest' when calling createUpdateOrchestrationConfig");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/registry/v2/orchestrationConfigs").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<OrchestrationConfigPostResponse> localVarReturnType = new ParameterizedTypeReference<OrchestrationConfigPostResponse>(){};
        return (OrchestrationConfigPostResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public OrchestrationConfigPostResponse createUpdateOrchestrationConfig(@Nonnull OrchestrationConfigPostRequest orchestrationConfigPostRequest) throws OpenApiRequestException {
        return this.createUpdateOrchestrationConfig(orchestrationConfigPostRequest, null);
    }

    @Nonnull
    public OrchestrationConfigDeleteResponse deleteOrchestrationConfig(@Nonnull UUID orchestrationConfigId, @Nullable String aiResourceGroup) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (orchestrationConfigId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'orchestrationConfigId' when calling deleteOrchestrationConfig");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("orchestrationConfigId", orchestrationConfigId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/registry/v2/orchestrationConfigs/{orchestrationConfigId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<OrchestrationConfigDeleteResponse> localVarReturnType = new ParameterizedTypeReference<OrchestrationConfigDeleteResponse>(){};
        return (OrchestrationConfigDeleteResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.DELETE, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public OrchestrationConfigDeleteResponse deleteOrchestrationConfig(@Nonnull UUID orchestrationConfigId) throws OpenApiRequestException {
        return this.deleteOrchestrationConfig(orchestrationConfigId, null);
    }

    @Nonnull
    public File exportOrchestrationConfig(@Nonnull UUID orchestrationConfigId, @Nullable String aiResourceGroup) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (orchestrationConfigId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'orchestrationConfigId' when calling exportOrchestrationConfig");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("orchestrationConfigId", orchestrationConfigId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/registry/v2/orchestrationConfigs/{orchestrationConfigId}/export").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/octet-stream", "application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>(){};
        return (File)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public File exportOrchestrationConfig(@Nonnull UUID orchestrationConfigId) throws OpenApiRequestException {
        return this.exportOrchestrationConfig(orchestrationConfigId, null);
    }

    @Nonnull
    public OrchestrationConfigGetResponse getOrchestrationConfigByUuid(@Nonnull UUID orchestrationConfigId, @Nullable String aiResourceGroup, @Nullable Boolean resolveTemplateRef) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (orchestrationConfigId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'orchestrationConfigId' when calling getOrchestrationConfigByUuid");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("orchestrationConfigId", orchestrationConfigId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/registry/v2/orchestrationConfigs/{orchestrationConfigId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "resolve_template_ref", (Object)resolveTemplateRef));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<OrchestrationConfigGetResponse> localVarReturnType = new ParameterizedTypeReference<OrchestrationConfigGetResponse>(){};
        return (OrchestrationConfigGetResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public OrchestrationConfigGetResponse getOrchestrationConfigByUuid(@Nonnull UUID orchestrationConfigId) throws OpenApiRequestException {
        return this.getOrchestrationConfigByUuid(orchestrationConfigId, null, null);
    }

    @Nonnull
    public OrchestrationConfigPostResponse importOrchestrationConfig(@Nullable String aiResourceGroup, @Nullable File _file) throws OpenApiRequestException {
        Object localVarPostBody = null;
        String localVarPath = UriComponentsBuilder.fromPath((String)"/registry/v2/orchestrationConfigs/import").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        if (_file != null) {
            localVarFormParams.add((Object)"file", (Object)new FileSystemResource(_file));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<OrchestrationConfigPostResponse> localVarReturnType = new ParameterizedTypeReference<OrchestrationConfigPostResponse>(){};
        return (OrchestrationConfigPostResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public OrchestrationConfigPostResponse importOrchestrationConfig() throws OpenApiRequestException {
        return this.importOrchestrationConfig(null, null);
    }

    @Nonnull
    public OrchestrationConfigListResponse listOrchestrationConfigHistory(@Nonnull String scenario, @Nonnull String version, @Nonnull String name, @Nullable String aiResourceGroup, @Nullable Boolean includeSpec, @Nullable Boolean resolveTemplateRef) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (scenario == null) {
            throw new OpenApiRequestException("Missing the required parameter 'scenario' when calling listOrchestrationConfigHistory");
        }
        if (version == null) {
            throw new OpenApiRequestException("Missing the required parameter 'version' when calling listOrchestrationConfigHistory");
        }
        if (name == null) {
            throw new OpenApiRequestException("Missing the required parameter 'name' when calling listOrchestrationConfigHistory");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("scenario", scenario);
        localVarPathParams.put("version", version);
        localVarPathParams.put("name", name);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/registry/v2/scenarios/{scenario}/orchestrationConfigs/{name}/versions/{version}/history").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "include_spec", (Object)includeSpec));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "resolve_template_ref", (Object)resolveTemplateRef));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<OrchestrationConfigListResponse> localVarReturnType = new ParameterizedTypeReference<OrchestrationConfigListResponse>(){};
        return (OrchestrationConfigListResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public OrchestrationConfigListResponse listOrchestrationConfigHistory(@Nonnull String scenario, @Nonnull String version, @Nonnull String name) throws OpenApiRequestException {
        return this.listOrchestrationConfigHistory(scenario, version, name, null, null, null);
    }

    @Nonnull
    public OrchestrationConfigListResponse listOrchestrationConfigs(@Nullable String aiResourceGroup, @Nullable String scenario, @Nullable String name, @Nullable String version, @Nullable String retrieve, @Nullable Boolean includeSpec, @Nullable Boolean resolveTemplateRef) throws OpenApiRequestException {
        Object localVarPostBody = null;
        String localVarPath = UriComponentsBuilder.fromPath((String)"/registry/v2/orchestrationConfigs").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "scenario", (Object)scenario));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "name", (Object)name));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "version", (Object)version));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "retrieve", (Object)retrieve));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "include_spec", (Object)includeSpec));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "resolve_template_ref", (Object)resolveTemplateRef));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<OrchestrationConfigListResponse> localVarReturnType = new ParameterizedTypeReference<OrchestrationConfigListResponse>(){};
        return (OrchestrationConfigListResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public OrchestrationConfigListResponse listOrchestrationConfigs() throws OpenApiRequestException {
        return this.listOrchestrationConfigs(null, null, null, null, null, null, null);
    }
}

