/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.client;

import com.google.common.annotations.Beta;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplateDeleteResponse;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplateGetResponse;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplateListResponse;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplatePostRequest;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplatePostResponse;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplateSubstitutionRequest;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplateSubstitutionResponse;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.services.openapi.apiclient.ApiClient;
import com.sap.cloud.sdk.services.openapi.core.AbstractOpenApiService;
import com.sap.cloud.sdk.services.openapi.core.OpenApiRequestException;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.io.FileSystemResource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class PromptTemplatesApi
extends AbstractOpenApiService {
    public PromptTemplatesApi(@Nonnull Destination httpDestination) {
        super(httpDestination);
    }

    @Beta
    public PromptTemplatesApi(@Nonnull ApiClient apiClient) {
        super(apiClient);
    }

    @Nonnull
    public PromptTemplatePostResponse createUpdatePromptTemplate(@Nonnull PromptTemplatePostRequest promptTemplatePostRequest, @Nullable String aiResourceGroup, @Nullable String aiResourceGroupScope) throws OpenApiRequestException {
        PromptTemplatePostRequest localVarPostBody = promptTemplatePostRequest;
        if (promptTemplatePostRequest == null) {
            throw new OpenApiRequestException("Missing the required parameter 'promptTemplatePostRequest' when calling createUpdatePromptTemplate");
        }
        String localVarPath = UriComponentsBuilder.fromPath((String)"/lm/promptTemplates").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        if (aiResourceGroupScope != null) {
            localVarHeaderParams.add("AI-Resource-Group-Scope", this.apiClient.parameterToString((Object)aiResourceGroupScope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PromptTemplatePostResponse> localVarReturnType = new ParameterizedTypeReference<PromptTemplatePostResponse>(){};
        return (PromptTemplatePostResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public PromptTemplatePostResponse createUpdatePromptTemplate(@Nonnull PromptTemplatePostRequest promptTemplatePostRequest) throws OpenApiRequestException {
        return this.createUpdatePromptTemplate(promptTemplatePostRequest, null, null);
    }

    @Nonnull
    public PromptTemplateDeleteResponse deletePromptTemplate(@Nonnull UUID promptTemplateId, @Nullable String aiResourceGroup, @Nullable String aiResourceGroupScope) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (promptTemplateId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'promptTemplateId' when calling deletePromptTemplate");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("promptTemplateId", promptTemplateId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/lm/promptTemplates/{promptTemplateId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        if (aiResourceGroupScope != null) {
            localVarHeaderParams.add("AI-Resource-Group-Scope", this.apiClient.parameterToString((Object)aiResourceGroupScope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PromptTemplateDeleteResponse> localVarReturnType = new ParameterizedTypeReference<PromptTemplateDeleteResponse>(){};
        return (PromptTemplateDeleteResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.DELETE, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public PromptTemplateDeleteResponse deletePromptTemplate(@Nonnull UUID promptTemplateId) throws OpenApiRequestException {
        return this.deletePromptTemplate(promptTemplateId, null, null);
    }

    @Nonnull
    public File exportPromptTemplate(@Nonnull UUID promptTemplateId, @Nullable String aiResourceGroup, @Nullable String aiResourceGroupScope) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (promptTemplateId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'promptTemplateId' when calling exportPromptTemplate");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("promptTemplateId", promptTemplateId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/lm/promptTemplates/{promptTemplateId}/export").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        if (aiResourceGroupScope != null) {
            localVarHeaderParams.add("AI-Resource-Group-Scope", this.apiClient.parameterToString((Object)aiResourceGroupScope));
        }
        String[] localVarAccepts = new String[]{"application/octet-stream", "application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<File> localVarReturnType = new ParameterizedTypeReference<File>(){};
        return (File)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public File exportPromptTemplate(@Nonnull UUID promptTemplateId) throws OpenApiRequestException {
        return this.exportPromptTemplate(promptTemplateId, null, null);
    }

    @Nonnull
    public PromptTemplateGetResponse getPromptTemplateByUuid(@Nonnull UUID promptTemplateId, @Nullable String aiResourceGroup, @Nullable String aiResourceGroupScope) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (promptTemplateId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'promptTemplateId' when calling getPromptTemplateByUuid");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("promptTemplateId", promptTemplateId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/lm/promptTemplates/{promptTemplateId}").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        if (aiResourceGroupScope != null) {
            localVarHeaderParams.add("AI-Resource-Group-Scope", this.apiClient.parameterToString((Object)aiResourceGroupScope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PromptTemplateGetResponse> localVarReturnType = new ParameterizedTypeReference<PromptTemplateGetResponse>(){};
        return (PromptTemplateGetResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public PromptTemplateGetResponse getPromptTemplateByUuid(@Nonnull UUID promptTemplateId) throws OpenApiRequestException {
        return this.getPromptTemplateByUuid(promptTemplateId, null, null);
    }

    @Nonnull
    public PromptTemplatePostResponse importPromptTemplate(@Nullable String aiResourceGroup, @Nullable String aiResourceGroupScope, @Nullable File _file) throws OpenApiRequestException {
        Object localVarPostBody = null;
        String localVarPath = UriComponentsBuilder.fromPath((String)"/lm/promptTemplates/import").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        if (aiResourceGroupScope != null) {
            localVarHeaderParams.add("AI-Resource-Group-Scope", this.apiClient.parameterToString((Object)aiResourceGroupScope));
        }
        if (_file != null) {
            localVarFormParams.add((Object)"file", (Object)new FileSystemResource(_file));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PromptTemplatePostResponse> localVarReturnType = new ParameterizedTypeReference<PromptTemplatePostResponse>(){};
        return (PromptTemplatePostResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public PromptTemplatePostResponse importPromptTemplate() throws OpenApiRequestException {
        return this.importPromptTemplate(null, null, null);
    }

    @Nonnull
    public PromptTemplateListResponse listPromptTemplateHistory(@Nonnull String scenario, @Nonnull String version, @Nonnull String name, @Nullable String aiResourceGroup, @Nullable String aiResourceGroupScope) throws OpenApiRequestException {
        Object localVarPostBody = null;
        if (scenario == null) {
            throw new OpenApiRequestException("Missing the required parameter 'scenario' when calling listPromptTemplateHistory");
        }
        if (version == null) {
            throw new OpenApiRequestException("Missing the required parameter 'version' when calling listPromptTemplateHistory");
        }
        if (name == null) {
            throw new OpenApiRequestException("Missing the required parameter 'name' when calling listPromptTemplateHistory");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("scenario", scenario);
        localVarPathParams.put("version", version);
        localVarPathParams.put("name", name);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/lm/scenarios/{scenario}/promptTemplates/{name}/versions/{version}/history").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        if (aiResourceGroupScope != null) {
            localVarHeaderParams.add("AI-Resource-Group-Scope", this.apiClient.parameterToString((Object)aiResourceGroupScope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PromptTemplateListResponse> localVarReturnType = new ParameterizedTypeReference<PromptTemplateListResponse>(){};
        return (PromptTemplateListResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public PromptTemplateListResponse listPromptTemplateHistory(@Nonnull String scenario, @Nonnull String version, @Nonnull String name) throws OpenApiRequestException {
        return this.listPromptTemplateHistory(scenario, version, name, null, null);
    }

    @Nonnull
    public PromptTemplateListResponse listPromptTemplates(@Nullable String aiResourceGroup, @Nullable String aiResourceGroupScope, @Nullable String scenario, @Nullable String name, @Nullable String version, @Nullable String retrieve, @Nullable Boolean includeSpec) throws OpenApiRequestException {
        Object localVarPostBody = null;
        String localVarPath = UriComponentsBuilder.fromPath((String)"/lm/promptTemplates").build().toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "scenario", (Object)scenario));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "name", (Object)name));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "version", (Object)version));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "retrieve", (Object)retrieve));
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "includeSpec", (Object)includeSpec));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        if (aiResourceGroupScope != null) {
            localVarHeaderParams.add("AI-Resource-Group-Scope", this.apiClient.parameterToString((Object)aiResourceGroupScope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PromptTemplateListResponse> localVarReturnType = new ParameterizedTypeReference<PromptTemplateListResponse>(){};
        return (PromptTemplateListResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.GET, (MultiValueMap)localVarQueryParams, localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public PromptTemplateListResponse listPromptTemplates() throws OpenApiRequestException {
        return this.listPromptTemplates(null, null, null, null, null, null, null);
    }

    @Nonnull
    public PromptTemplateSubstitutionResponse parsePromptTemplateById(@Nonnull UUID promptTemplateId, @Nullable String aiResourceGroup, @Nullable String aiResourceGroupScope, @Nullable Boolean metadata, @Nullable PromptTemplateSubstitutionRequest promptTemplateSubstitutionRequest) throws OpenApiRequestException {
        PromptTemplateSubstitutionRequest localVarPostBody = promptTemplateSubstitutionRequest;
        if (promptTemplateId == null) {
            throw new OpenApiRequestException("Missing the required parameter 'promptTemplateId' when calling parsePromptTemplateById");
        }
        HashMap<String, UUID> localVarPathParams = new HashMap<String, UUID>();
        localVarPathParams.put("promptTemplateId", promptTemplateId);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/lm/promptTemplates/{promptTemplateId}/substitution").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "metadata", (Object)metadata));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        if (aiResourceGroupScope != null) {
            localVarHeaderParams.add("AI-Resource-Group-Scope", this.apiClient.parameterToString((Object)aiResourceGroupScope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PromptTemplateSubstitutionResponse> localVarReturnType = new ParameterizedTypeReference<PromptTemplateSubstitutionResponse>(){};
        return (PromptTemplateSubstitutionResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public PromptTemplateSubstitutionResponse parsePromptTemplateById(@Nonnull UUID promptTemplateId) throws OpenApiRequestException {
        return this.parsePromptTemplateById(promptTemplateId, null, null, null, null);
    }

    @Nonnull
    public PromptTemplateSubstitutionResponse parsePromptTemplateByNameVersion(@Nonnull String scenario, @Nonnull String version, @Nonnull String name, @Nullable String aiResourceGroup, @Nullable String aiResourceGroupScope, @Nullable Boolean metadata, @Nullable PromptTemplateSubstitutionRequest promptTemplateSubstitutionRequest) throws OpenApiRequestException {
        PromptTemplateSubstitutionRequest localVarPostBody = promptTemplateSubstitutionRequest;
        if (scenario == null) {
            throw new OpenApiRequestException("Missing the required parameter 'scenario' when calling parsePromptTemplateByNameVersion");
        }
        if (version == null) {
            throw new OpenApiRequestException("Missing the required parameter 'version' when calling parsePromptTemplateByNameVersion");
        }
        if (name == null) {
            throw new OpenApiRequestException("Missing the required parameter 'name' when calling parsePromptTemplateByNameVersion");
        }
        HashMap<String, String> localVarPathParams = new HashMap<String, String>();
        localVarPathParams.put("scenario", scenario);
        localVarPathParams.put("version", version);
        localVarPathParams.put("name", name);
        String localVarPath = UriComponentsBuilder.fromPath((String)"/lm/scenarios/{scenario}/promptTemplates/{name}/versions/{version}/substitution").buildAndExpand(localVarPathParams).toUriString();
        LinkedMultiValueMap localVarQueryParams = new LinkedMultiValueMap();
        HttpHeaders localVarHeaderParams = new HttpHeaders();
        LinkedMultiValueMap localVarFormParams = new LinkedMultiValueMap();
        localVarQueryParams.putAll((Map)this.apiClient.parameterToMultiValueMap(null, "metadata", (Object)metadata));
        if (aiResourceGroup != null) {
            localVarHeaderParams.add("AI-Resource-Group", this.apiClient.parameterToString((Object)aiResourceGroup));
        }
        if (aiResourceGroupScope != null) {
            localVarHeaderParams.add("AI-Resource-Group-Scope", this.apiClient.parameterToString((Object)aiResourceGroupScope));
        }
        String[] localVarAccepts = new String[]{"application/json"};
        List localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{};
        ParameterizedTypeReference<PromptTemplateSubstitutionResponse> localVarReturnType = new ParameterizedTypeReference<PromptTemplateSubstitutionResponse>(){};
        return (PromptTemplateSubstitutionResponse)this.apiClient.invokeAPI(localVarPath, HttpMethod.POST, (MultiValueMap)localVarQueryParams, (Object)localVarPostBody, localVarHeaderParams, (MultiValueMap)localVarFormParams, localVarAccept, localVarContentType, localVarAuthNames, (ParameterizedTypeReference)localVarReturnType);
    }

    @Nonnull
    public PromptTemplateSubstitutionResponse parsePromptTemplateByNameVersion(@Nonnull String scenario, @Nonnull String version, @Nonnull String name) throws OpenApiRequestException {
        return this.parsePromptTemplateByNameVersion(scenario, version, name, null, null, null, null);
    }
}

