/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sap.ai.sdk.prompt.registry.model.ChatMessage;
import com.sap.ai.sdk.prompt.registry.model.ChatMessageContent;
import com.sap.ai.sdk.prompt.registry.model.MessageToolCall;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AssistantChatMessage
implements ChatMessage {
    @JsonProperty(value="role")
    private RoleEnum role;
    @JsonProperty(value="content")
    private ChatMessageContent content;
    @JsonProperty(value="refusal")
    private String refusal;
    @JsonProperty(value="tool_calls")
    private List<MessageToolCall> toolCalls = new ArrayList<MessageToolCall>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected AssistantChatMessage() {
    }

    @Nonnull
    public AssistantChatMessage role(@Nonnull RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nonnull
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(@Nonnull RoleEnum role) {
        this.role = role;
    }

    @Nonnull
    public AssistantChatMessage content(@Nullable ChatMessageContent content) {
        this.content = content;
        return this;
    }

    @Nonnull
    public ChatMessageContent getContent() {
        return this.content;
    }

    public void setContent(@Nullable ChatMessageContent content) {
        this.content = content;
    }

    @Nonnull
    public AssistantChatMessage refusal(@Nullable String refusal) {
        this.refusal = refusal;
        return this;
    }

    @Nonnull
    public String getRefusal() {
        return this.refusal;
    }

    public void setRefusal(@Nullable String refusal) {
        this.refusal = refusal;
    }

    @Nonnull
    public AssistantChatMessage toolCalls(@Nullable List<MessageToolCall> toolCalls) {
        this.toolCalls = toolCalls;
        return this;
    }

    @Nonnull
    public AssistantChatMessage addToolCallsItem(@Nonnull MessageToolCall toolCallsItem) {
        if (this.toolCalls == null) {
            this.toolCalls = new ArrayList<MessageToolCall>();
        }
        this.toolCalls.add(toolCallsItem);
        return this;
    }

    @Nonnull
    public List<MessageToolCall> getToolCalls() {
        return this.toolCalls;
    }

    public void setToolCalls(@Nullable List<MessageToolCall> toolCalls) {
        this.toolCalls = toolCalls;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("AssistantChatMessage has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.role != null) {
            declaredFields.put("role", (Object)this.role);
        }
        if (this.content != null) {
            declaredFields.put("content", this.content);
        }
        if (this.refusal != null) {
            declaredFields.put("refusal", this.refusal);
        }
        if (this.toolCalls != null) {
            declaredFields.put("toolCalls", this.toolCalls);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssistantChatMessage assistantChatMessage = (AssistantChatMessage)o;
        return Objects.equals(this.cloudSdkCustomFields, assistantChatMessage.cloudSdkCustomFields) && Objects.equals((Object)this.role, (Object)assistantChatMessage.role) && Objects.equals(this.content, assistantChatMessage.content) && Objects.equals(this.refusal, assistantChatMessage.refusal) && Objects.equals(this.toolCalls, assistantChatMessage.toolCalls);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.content, this.refusal, this.toolCalls, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AssistantChatMessage {\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    refusal: ").append(this.toIndentedString(this.refusal)).append("\n");
        sb.append("    toolCalls: ").append(this.toIndentedString(this.toolCalls)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return role -> new AssistantChatMessage().role(role);
    }

    public static enum RoleEnum {
        ASSISTANT("assistant"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static RoleEnum fromValue(@Nonnull String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static interface Builder {
        public AssistantChatMessage role(@Nonnull RoleEnum var1);
    }
}

