/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sap.ai.sdk.prompt.registry.model.AzureContentSafetyOutput;
import com.sap.ai.sdk.prompt.registry.model.OutputFilterConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureContentSafetyOutputFilterConfig
implements OutputFilterConfig {
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="config")
    private AzureContentSafetyOutput config;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected AzureContentSafetyOutputFilterConfig() {
    }

    @Nonnull
    public AzureContentSafetyOutputFilterConfig type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    @Nonnull
    public AzureContentSafetyOutputFilterConfig config(@Nullable AzureContentSafetyOutput config) {
        this.config = config;
        return this;
    }

    @Nonnull
    public AzureContentSafetyOutput getConfig() {
        return this.config;
    }

    public void setConfig(@Nullable AzureContentSafetyOutput config) {
        this.config = config;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("AzureContentSafetyOutputFilterConfig has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.type != null) {
            declaredFields.put("type", (Object)this.type);
        }
        if (this.config != null) {
            declaredFields.put("config", this.config);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AzureContentSafetyOutputFilterConfig azureContentSafetyOutputFilterConfig = (AzureContentSafetyOutputFilterConfig)o;
        return Objects.equals(this.cloudSdkCustomFields, azureContentSafetyOutputFilterConfig.cloudSdkCustomFields) && Objects.equals((Object)this.type, (Object)azureContentSafetyOutputFilterConfig.type) && Objects.equals(this.config, azureContentSafetyOutputFilterConfig.config);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.config, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AzureContentSafetyOutputFilterConfig {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    config: ").append(this.toIndentedString(this.config)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return type -> new AzureContentSafetyOutputFilterConfig().type(type);
    }

    public static enum TypeEnum {
        AZURE_CONTENT_SAFETY("azure_content_safety"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static TypeEnum fromValue(@Nonnull String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static interface Builder {
        public AzureContentSafetyOutputFilterConfig type(@Nonnull TypeEnum var1);
    }
}

