/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sap.ai.sdk.prompt.registry.model.DPIConfigMaskGroundingInput;
import com.sap.ai.sdk.prompt.registry.model.DPIEntityConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DPIConfig {
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="method")
    private MethodEnum method;
    @JsonProperty(value="entities")
    private List<DPIEntityConfig> entities = new ArrayList<DPIEntityConfig>();
    @JsonProperty(value="allowlist")
    private List<String> allowlist = new ArrayList<String>();
    @JsonProperty(value="mask_grounding_input")
    private DPIConfigMaskGroundingInput maskGroundingInput;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected DPIConfig() {
    }

    @Nonnull
    public DPIConfig type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    @Nonnull
    public DPIConfig method(@Nonnull MethodEnum method) {
        this.method = method;
        return this;
    }

    @Nonnull
    public MethodEnum getMethod() {
        return this.method;
    }

    public void setMethod(@Nonnull MethodEnum method) {
        this.method = method;
    }

    @Nonnull
    public DPIConfig entities(@Nonnull List<DPIEntityConfig> entities) {
        this.entities = entities;
        return this;
    }

    @Nonnull
    public DPIConfig addEntitiesItem(@Nonnull DPIEntityConfig entitiesItem) {
        if (this.entities == null) {
            this.entities = new ArrayList<DPIEntityConfig>();
        }
        this.entities.add(entitiesItem);
        return this;
    }

    @Nonnull
    public List<DPIEntityConfig> getEntities() {
        return this.entities;
    }

    public void setEntities(@Nonnull List<DPIEntityConfig> entities) {
        this.entities = entities;
    }

    @Nonnull
    public DPIConfig allowlist(@Nullable List<String> allowlist) {
        this.allowlist = allowlist;
        return this;
    }

    @Nonnull
    public DPIConfig addAllowlistItem(@Nonnull String allowlistItem) {
        if (this.allowlist == null) {
            this.allowlist = new ArrayList<String>();
        }
        this.allowlist.add(allowlistItem);
        return this;
    }

    @Nonnull
    public List<String> getAllowlist() {
        return this.allowlist;
    }

    public void setAllowlist(@Nullable List<String> allowlist) {
        this.allowlist = allowlist;
    }

    @Nonnull
    public DPIConfig maskGroundingInput(@Nullable DPIConfigMaskGroundingInput maskGroundingInput) {
        this.maskGroundingInput = maskGroundingInput;
        return this;
    }

    @Nonnull
    public DPIConfigMaskGroundingInput getMaskGroundingInput() {
        return this.maskGroundingInput;
    }

    public void setMaskGroundingInput(@Nullable DPIConfigMaskGroundingInput maskGroundingInput) {
        this.maskGroundingInput = maskGroundingInput;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("DPIConfig has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.type != null) {
            declaredFields.put("type", (Object)this.type);
        }
        if (this.method != null) {
            declaredFields.put("method", (Object)this.method);
        }
        if (this.entities != null) {
            declaredFields.put("entities", this.entities);
        }
        if (this.allowlist != null) {
            declaredFields.put("allowlist", this.allowlist);
        }
        if (this.maskGroundingInput != null) {
            declaredFields.put("maskGroundingInput", this.maskGroundingInput);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DPIConfig dpIConfig = (DPIConfig)o;
        return Objects.equals(this.cloudSdkCustomFields, dpIConfig.cloudSdkCustomFields) && Objects.equals((Object)this.type, (Object)dpIConfig.type) && Objects.equals((Object)this.method, (Object)dpIConfig.method) && Objects.equals(this.entities, dpIConfig.entities) && Objects.equals(this.allowlist, dpIConfig.allowlist) && Objects.equals(this.maskGroundingInput, dpIConfig.maskGroundingInput);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.method, this.entities, this.allowlist, this.maskGroundingInput, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DPIConfig {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    entities: ").append(this.toIndentedString(this.entities)).append("\n");
        sb.append("    allowlist: ").append(this.toIndentedString(this.allowlist)).append("\n");
        sb.append("    maskGroundingInput: ").append(this.toIndentedString(this.maskGroundingInput)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return type -> method -> entities -> new DPIConfig().type(type).method(method).entities(entities);
    }

    public static enum TypeEnum {
        SAP_DATA_PRIVACY_INTEGRATION("sap_data_privacy_integration"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static TypeEnum fromValue(@Nonnull String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static enum MethodEnum {
        ANONYMIZATION("anonymization"),
        PSEUDONYMIZATION("pseudonymization"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static MethodEnum fromValue(@Nonnull String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static interface Builder {
        public Builder1 type(@Nonnull TypeEnum var1);
    }

    public static interface Builder1 {
        public Builder2 method(@Nonnull MethodEnum var1);
    }

    public static interface Builder2 {
        public DPIConfig entities(@Nonnull List<DPIEntityConfig> var1);

        default public DPIConfig entities(DPIEntityConfig ... entities) {
            return this.entities(Arrays.asList(entities));
        }
    }
}

