/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.DPIEntityConfig;
import com.sap.ai.sdk.prompt.registry.model.DPIMethodConstant;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DPICustomEntity
implements DPIEntityConfig {
    @JsonProperty(value="regex")
    private String regex;
    @JsonProperty(value="replacement_strategy")
    private DPIMethodConstant replacementStrategy;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected DPICustomEntity() {
    }

    @Nonnull
    public DPICustomEntity regex(@Nonnull String regex) {
        this.regex = regex;
        return this;
    }

    @Nonnull
    public String getRegex() {
        return this.regex;
    }

    public void setRegex(@Nonnull String regex) {
        this.regex = regex;
    }

    @Nonnull
    public DPICustomEntity replacementStrategy(@Nonnull DPIMethodConstant replacementStrategy) {
        this.replacementStrategy = replacementStrategy;
        return this;
    }

    @Nonnull
    public DPIMethodConstant getReplacementStrategy() {
        return this.replacementStrategy;
    }

    public void setReplacementStrategy(@Nonnull DPIMethodConstant replacementStrategy) {
        this.replacementStrategy = replacementStrategy;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("DPICustomEntity has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.regex != null) {
            declaredFields.put("regex", this.regex);
        }
        if (this.replacementStrategy != null) {
            declaredFields.put("replacementStrategy", this.replacementStrategy);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DPICustomEntity dpICustomEntity = (DPICustomEntity)o;
        return Objects.equals(this.cloudSdkCustomFields, dpICustomEntity.cloudSdkCustomFields) && Objects.equals(this.regex, dpICustomEntity.regex) && Objects.equals(this.replacementStrategy, dpICustomEntity.replacementStrategy);
    }

    public int hashCode() {
        return Objects.hash(this.regex, this.replacementStrategy, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DPICustomEntity {\n");
        sb.append("    regex: ").append(this.toIndentedString(this.regex)).append("\n");
        sb.append("    replacementStrategy: ").append(this.toIndentedString(this.replacementStrategy)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return regex -> replacementStrategy -> new DPICustomEntity().regex(regex).replacementStrategy(replacementStrategy);
    }

    public static interface Builder {
        public Builder1 regex(@Nonnull String var1);
    }

    public static interface Builder1 {
        public DPICustomEntity replacementStrategy(@Nonnull DPIMethodConstant var1);
    }
}

