/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sap.ai.sdk.prompt.registry.model.DPIStandardEntityReplacementStrategy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DPIMethodConstant
implements DPIStandardEntityReplacementStrategy {
    @JsonProperty(value="method")
    private MethodEnum method;
    @JsonProperty(value="value")
    private String value;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected DPIMethodConstant() {
    }

    @Nonnull
    public DPIMethodConstant method(@Nonnull MethodEnum method) {
        this.method = method;
        return this;
    }

    @Nonnull
    public MethodEnum getMethod() {
        return this.method;
    }

    public void setMethod(@Nonnull MethodEnum method) {
        this.method = method;
    }

    @Nonnull
    public DPIMethodConstant value(@Nonnull String value) {
        this.value = value;
        return this;
    }

    @Nonnull
    public String getValue() {
        return this.value;
    }

    public void setValue(@Nonnull String value) {
        this.value = value;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("DPIMethodConstant has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.method != null) {
            declaredFields.put("method", (Object)this.method);
        }
        if (this.value != null) {
            declaredFields.put("value", this.value);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DPIMethodConstant dpIMethodConstant = (DPIMethodConstant)o;
        return Objects.equals(this.cloudSdkCustomFields, dpIMethodConstant.cloudSdkCustomFields) && Objects.equals((Object)this.method, (Object)dpIMethodConstant.method) && Objects.equals(this.value, dpIMethodConstant.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.value, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DPIMethodConstant {\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return method -> value -> new DPIMethodConstant().method(method).value(value);
    }

    public static enum MethodEnum {
        CONSTANT("constant"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private MethodEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static MethodEnum fromValue(@Nonnull String value) {
            for (MethodEnum b : MethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static interface Builder {
        public Builder1 method(@Nonnull MethodEnum var1);
    }

    public static interface Builder1 {
        public DPIMethodConstant value(@Nonnull String var1);
    }
}

