/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.DPIEntities;
import com.sap.ai.sdk.prompt.registry.model.DPIEntityConfig;
import com.sap.ai.sdk.prompt.registry.model.DPIStandardEntityReplacementStrategy;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DPIStandardEntity
implements DPIEntityConfig {
    @JsonProperty(value="type")
    private DPIEntities type;
    @JsonProperty(value="replacement_strategy")
    private DPIStandardEntityReplacementStrategy replacementStrategy;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected DPIStandardEntity() {
    }

    @Nonnull
    public DPIStandardEntity type(@Nonnull DPIEntities type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public DPIEntities getType() {
        return this.type;
    }

    public void setType(@Nonnull DPIEntities type) {
        this.type = type;
    }

    @Nonnull
    public DPIStandardEntity replacementStrategy(@Nullable DPIStandardEntityReplacementStrategy replacementStrategy) {
        this.replacementStrategy = replacementStrategy;
        return this;
    }

    @Nonnull
    public DPIStandardEntityReplacementStrategy getReplacementStrategy() {
        return this.replacementStrategy;
    }

    public void setReplacementStrategy(@Nullable DPIStandardEntityReplacementStrategy replacementStrategy) {
        this.replacementStrategy = replacementStrategy;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("DPIStandardEntity has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.type != null) {
            declaredFields.put("type", (Object)this.type);
        }
        if (this.replacementStrategy != null) {
            declaredFields.put("replacementStrategy", this.replacementStrategy);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DPIStandardEntity dpIStandardEntity = (DPIStandardEntity)o;
        return Objects.equals(this.cloudSdkCustomFields, dpIStandardEntity.cloudSdkCustomFields) && Objects.equals((Object)this.type, (Object)dpIStandardEntity.type) && Objects.equals(this.replacementStrategy, dpIStandardEntity.replacementStrategy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.replacementStrategy, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DPIStandardEntity {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    replacementStrategy: ").append(this.toIndentedString(this.replacementStrategy)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return type -> new DPIStandardEntity().type(type);
    }

    public static interface Builder {
        public DPIStandardEntity type(@Nonnull DPIEntities var1);
    }
}

