/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.InputFilteringConfig;
import com.sap.ai.sdk.prompt.registry.model.OutputFilteringConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FilteringModuleConfig {
    @JsonProperty(value="input")
    private InputFilteringConfig input;
    @JsonProperty(value="output")
    private OutputFilteringConfig output;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected FilteringModuleConfig() {
    }

    @Nonnull
    public FilteringModuleConfig input(@Nullable InputFilteringConfig input) {
        this.input = input;
        return this;
    }

    @Nonnull
    public InputFilteringConfig getInput() {
        return this.input;
    }

    public void setInput(@Nullable InputFilteringConfig input) {
        this.input = input;
    }

    @Nonnull
    public FilteringModuleConfig output(@Nullable OutputFilteringConfig output) {
        this.output = output;
        return this;
    }

    @Nonnull
    public OutputFilteringConfig getOutput() {
        return this.output;
    }

    public void setOutput(@Nullable OutputFilteringConfig output) {
        this.output = output;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("FilteringModuleConfig has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.input != null) {
            declaredFields.put("input", this.input);
        }
        if (this.output != null) {
            declaredFields.put("output", this.output);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteringModuleConfig filteringModuleConfig = (FilteringModuleConfig)o;
        return Objects.equals(this.cloudSdkCustomFields, filteringModuleConfig.cloudSdkCustomFields) && Objects.equals(this.input, filteringModuleConfig.input) && Objects.equals(this.output, filteringModuleConfig.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FilteringModuleConfig {\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static FilteringModuleConfig create() {
        return new FilteringModuleConfig();
    }
}

