/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class FunctionObject {
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="parameters")
    private Map<String, Object> parameters = new HashMap<String, Object>();
    @JsonProperty(value="strict")
    private Boolean strict = false;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected FunctionObject() {
    }

    @Nonnull
    public FunctionObject description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nonnull
    public FunctionObject name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public FunctionObject parameters(@Nullable Map<String, Object> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Nonnull
    public FunctionObject putparametersItem(@Nonnull String key, @Nullable Object parametersItem) {
        if (this.parameters == null) {
            this.parameters = new HashMap<String, Object>();
        }
        this.parameters.put(key, parametersItem);
        return this;
    }

    @Nonnull
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(@Nullable Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Nonnull
    public FunctionObject strict(@Nullable Boolean strict) {
        this.strict = strict;
        return this;
    }

    @Nullable
    public Boolean isStrict() {
        return this.strict;
    }

    public void setStrict(@Nullable Boolean strict) {
        this.strict = strict;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("FunctionObject has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.description != null) {
            declaredFields.put("description", this.description);
        }
        if (this.name != null) {
            declaredFields.put("name", this.name);
        }
        if (this.parameters != null) {
            declaredFields.put("parameters", this.parameters);
        }
        if (this.strict != null) {
            declaredFields.put("strict", this.strict);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionObject functionObject = (FunctionObject)o;
        return Objects.equals(this.cloudSdkCustomFields, functionObject.cloudSdkCustomFields) && Objects.equals(this.description, functionObject.description) && Objects.equals(this.name, functionObject.name) && Objects.equals(this.parameters, functionObject.parameters) && Objects.equals(this.strict, functionObject.strict);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.name, this.parameters, this.strict, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FunctionObject {\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    parameters: ").append(this.toIndentedString(this.parameters)).append("\n");
        sb.append("    strict: ").append(this.toIndentedString(this.strict)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return name -> new FunctionObject().name(name);
    }

    public static interface Builder {
        public FunctionObject name(@Nonnull String var1);
    }
}

