/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class GlobalStreamOptions {
    @JsonProperty(value="enabled")
    private Boolean enabled = false;
    @JsonProperty(value="chunk_size")
    private Integer chunkSize = 100;
    @JsonProperty(value="delimiters")
    private List<String> delimiters = new ArrayList<String>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected GlobalStreamOptions() {
    }

    @Nonnull
    public GlobalStreamOptions enabled(@Nullable Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    public Boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(@Nullable Boolean enabled) {
        this.enabled = enabled;
    }

    @Nonnull
    public GlobalStreamOptions chunkSize(@Nullable Integer chunkSize) {
        this.chunkSize = chunkSize;
        return this;
    }

    @Nonnull
    public Integer getChunkSize() {
        return this.chunkSize;
    }

    public void setChunkSize(@Nullable Integer chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Nonnull
    public GlobalStreamOptions delimiters(@Nullable List<String> delimiters) {
        this.delimiters = delimiters;
        return this;
    }

    @Nonnull
    public GlobalStreamOptions addDelimitersItem(@Nonnull String delimitersItem) {
        if (this.delimiters == null) {
            this.delimiters = new ArrayList<String>();
        }
        this.delimiters.add(delimitersItem);
        return this;
    }

    @Nonnull
    public List<String> getDelimiters() {
        return this.delimiters;
    }

    public void setDelimiters(@Nullable List<String> delimiters) {
        this.delimiters = delimiters;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("GlobalStreamOptions has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.enabled != null) {
            declaredFields.put("enabled", this.enabled);
        }
        if (this.chunkSize != null) {
            declaredFields.put("chunkSize", this.chunkSize);
        }
        if (this.delimiters != null) {
            declaredFields.put("delimiters", this.delimiters);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalStreamOptions globalStreamOptions = (GlobalStreamOptions)o;
        return Objects.equals(this.cloudSdkCustomFields, globalStreamOptions.cloudSdkCustomFields) && Objects.equals(this.enabled, globalStreamOptions.enabled) && Objects.equals(this.chunkSize, globalStreamOptions.chunkSize) && Objects.equals(this.delimiters, globalStreamOptions.delimiters);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.chunkSize, this.delimiters, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GlobalStreamOptions {\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("    chunkSize: ").append(this.toIndentedString(this.chunkSize)).append("\n");
        sb.append("    delimiters: ").append(this.toIndentedString(this.delimiters)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static GlobalStreamOptions create() {
        return new GlobalStreamOptions();
    }
}

