/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sap.ai.sdk.prompt.registry.model.ImageContentImageUrl;
import com.sap.ai.sdk.prompt.registry.model.MultiChatContent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImageContent
implements MultiChatContent {
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="image_url")
    private ImageContentImageUrl imageUrl;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected ImageContent() {
    }

    @Nonnull
    public ImageContent type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    @Nonnull
    public ImageContent imageUrl(@Nonnull ImageContentImageUrl imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    @Nonnull
    public ImageContentImageUrl getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(@Nonnull ImageContentImageUrl imageUrl) {
        this.imageUrl = imageUrl;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("ImageContent has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.type != null) {
            declaredFields.put("type", (Object)this.type);
        }
        if (this.imageUrl != null) {
            declaredFields.put("imageUrl", this.imageUrl);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageContent imageContent = (ImageContent)o;
        return Objects.equals(this.cloudSdkCustomFields, imageContent.cloudSdkCustomFields) && Objects.equals((Object)this.type, (Object)imageContent.type) && Objects.equals(this.imageUrl, imageContent.imageUrl);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.imageUrl, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageContent {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    imageUrl: ").append(this.toIndentedString(this.imageUrl)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return type -> imageUrl -> new ImageContent().type(type).imageUrl(imageUrl);
    }

    public static enum TypeEnum {
        IMAGE_URL("image_url"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static TypeEnum fromValue(@Nonnull String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static interface Builder {
        public Builder1 type(@Nonnull TypeEnum var1);
    }

    public static interface Builder1 {
        public ImageContent imageUrl(@Nonnull ImageContentImageUrl var1);
    }
}

