/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ImageContentUrl {
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="detail")
    private String detail = "auto";
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected ImageContentUrl() {
    }

    @Nonnull
    public ImageContentUrl url(@Nonnull String url) {
        this.url = url;
        return this;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public void setUrl(@Nonnull String url) {
        this.url = url;
    }

    @Nonnull
    public ImageContentUrl detail(@Nullable String detail) {
        this.detail = detail;
        return this;
    }

    @Nonnull
    public String getDetail() {
        return this.detail;
    }

    public void setDetail(@Nullable String detail) {
        this.detail = detail;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("ImageContentUrl has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.url != null) {
            declaredFields.put("url", this.url);
        }
        if (this.detail != null) {
            declaredFields.put("detail", this.detail);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageContentUrl imageContentUrl = (ImageContentUrl)o;
        return Objects.equals(this.cloudSdkCustomFields, imageContentUrl.cloudSdkCustomFields) && Objects.equals(this.url, imageContentUrl.url) && Objects.equals(this.detail, imageContentUrl.detail);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.detail, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ImageContentUrl {\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return url -> new ImageContentUrl().url(url);
    }

    public static interface Builder {
        public ImageContentUrl url(@Nonnull String var1);
    }
}

