/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.InputFilterConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class InputFilteringConfig {
    @JsonProperty(value="filters")
    private List<InputFilterConfig> filters = new ArrayList<InputFilterConfig>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected InputFilteringConfig() {
    }

    @Nonnull
    public InputFilteringConfig filters(@Nonnull List<InputFilterConfig> filters) {
        this.filters = filters;
        return this;
    }

    @Nonnull
    public InputFilteringConfig addFiltersItem(@Nonnull InputFilterConfig filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<InputFilterConfig>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @Nonnull
    public List<InputFilterConfig> getFilters() {
        return this.filters;
    }

    public void setFilters(@Nonnull List<InputFilterConfig> filters) {
        this.filters = filters;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("InputFilteringConfig has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.filters != null) {
            declaredFields.put("filters", this.filters);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InputFilteringConfig inputFilteringConfig = (InputFilteringConfig)o;
        return Objects.equals(this.cloudSdkCustomFields, inputFilteringConfig.cloudSdkCustomFields) && Objects.equals(this.filters, inputFilteringConfig.filters);
    }

    public int hashCode() {
        return Objects.hash(this.filters, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class InputFilteringConfig {\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return filters -> new InputFilteringConfig().filters(filters);
    }

    public static interface Builder {
        public InputFilteringConfig filters(@Nonnull List<InputFilterConfig> var1);

        default public InputFilteringConfig filters(InputFilterConfig ... filters) {
            return this.filters(Arrays.asList(filters));
        }
    }
}

