/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LLMModelDetails {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version = "latest";
    @JsonProperty(value="params")
    private Map<String, Object> params = new HashMap<String, Object>();
    @JsonProperty(value="timeout")
    private Integer timeout = 600;
    @JsonProperty(value="max_retries")
    private Integer maxRetries = 2;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected LLMModelDetails() {
    }

    @Nonnull
    public LLMModelDetails name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public LLMModelDetails version(@Nullable String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nullable String version) {
        this.version = version;
    }

    @Nonnull
    public LLMModelDetails params(@Nullable Map<String, Object> params) {
        this.params = params;
        return this;
    }

    @Nonnull
    public LLMModelDetails putparamsItem(@Nonnull String key, @Nullable Object paramsItem) {
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        this.params.put(key, paramsItem);
        return this;
    }

    @Nonnull
    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(@Nullable Map<String, Object> params) {
        this.params = params;
    }

    @Nonnull
    public LLMModelDetails timeout(@Nullable Integer timeout) {
        this.timeout = timeout;
        return this;
    }

    @Nonnull
    public Integer getTimeout() {
        return this.timeout;
    }

    public void setTimeout(@Nullable Integer timeout) {
        this.timeout = timeout;
    }

    @Nonnull
    public LLMModelDetails maxRetries(@Nullable Integer maxRetries) {
        this.maxRetries = maxRetries;
        return this;
    }

    @Nonnull
    public Integer getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(@Nullable Integer maxRetries) {
        this.maxRetries = maxRetries;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("LLMModelDetails has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.name != null) {
            declaredFields.put("name", this.name);
        }
        if (this.version != null) {
            declaredFields.put("version", this.version);
        }
        if (this.params != null) {
            declaredFields.put("params", this.params);
        }
        if (this.timeout != null) {
            declaredFields.put("timeout", this.timeout);
        }
        if (this.maxRetries != null) {
            declaredFields.put("maxRetries", this.maxRetries);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLMModelDetails llMModelDetails = (LLMModelDetails)o;
        return Objects.equals(this.cloudSdkCustomFields, llMModelDetails.cloudSdkCustomFields) && Objects.equals(this.name, llMModelDetails.name) && Objects.equals(this.version, llMModelDetails.version) && Objects.equals(this.params, llMModelDetails.params) && Objects.equals(this.timeout, llMModelDetails.timeout) && Objects.equals(this.maxRetries, llMModelDetails.maxRetries);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.params, this.timeout, this.maxRetries, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LLMModelDetails {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    params: ").append(this.toIndentedString(this.params)).append("\n");
        sb.append("    timeout: ").append(this.toIndentedString(this.timeout)).append("\n");
        sb.append("    maxRetries: ").append(this.toIndentedString(this.maxRetries)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return name -> new LLMModelDetails().name(name);
    }

    public static interface Builder {
        public LLMModelDetails name(@Nonnull String var1);
    }
}

