/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.DPIConfig;
import com.sap.ai.sdk.prompt.registry.model.MaskingModuleConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MaskingModuleConfigProviders
implements MaskingModuleConfig {
    @JsonProperty(value="providers")
    private List<DPIConfig> providers = new ArrayList<DPIConfig>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected MaskingModuleConfigProviders() {
    }

    @Nonnull
    public MaskingModuleConfigProviders providers(@Nonnull List<DPIConfig> providers) {
        this.providers = providers;
        return this;
    }

    @Nonnull
    public MaskingModuleConfigProviders addProvidersItem(@Nonnull DPIConfig providersItem) {
        if (this.providers == null) {
            this.providers = new ArrayList<DPIConfig>();
        }
        this.providers.add(providersItem);
        return this;
    }

    @Nonnull
    public List<DPIConfig> getProviders() {
        return this.providers;
    }

    public void setProviders(@Nonnull List<DPIConfig> providers) {
        this.providers = providers;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("MaskingModuleConfigProviders has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.providers != null) {
            declaredFields.put("providers", this.providers);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MaskingModuleConfigProviders maskingModuleConfigProviders = (MaskingModuleConfigProviders)o;
        return Objects.equals(this.cloudSdkCustomFields, maskingModuleConfigProviders.cloudSdkCustomFields) && Objects.equals(this.providers, maskingModuleConfigProviders.providers);
    }

    public int hashCode() {
        return Objects.hash(this.providers, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MaskingModuleConfigProviders {\n");
        sb.append("    providers: ").append(this.toIndentedString(this.providers)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return providers -> new MaskingModuleConfigProviders().providers(providers);
    }

    public static interface Builder {
        public MaskingModuleConfigProviders providers(@Nonnull List<DPIConfig> var1);

        default public MaskingModuleConfigProviders providers(DPIConfig ... providers) {
            return this.providers(Arrays.asList(providers));
        }
    }
}

