/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.MultiChatContent;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MultiChatTemplate
implements PromptTemplate {
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="content")
    private List<MultiChatContent> content = new ArrayList<MultiChatContent>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected MultiChatTemplate() {
    }

    @Nonnull
    public MultiChatTemplate role(@Nonnull String role) {
        this.role = role;
        return this;
    }

    @Nonnull
    public String getRole() {
        return this.role;
    }

    public void setRole(@Nonnull String role) {
        this.role = role;
    }

    @Nonnull
    public MultiChatTemplate content(@Nonnull List<MultiChatContent> content) {
        this.content = content;
        return this;
    }

    @Nonnull
    public MultiChatTemplate addContentItem(@Nonnull MultiChatContent contentItem) {
        if (this.content == null) {
            this.content = new ArrayList<MultiChatContent>();
        }
        this.content.add(contentItem);
        return this;
    }

    @Nonnull
    public List<MultiChatContent> getContent() {
        return this.content;
    }

    public void setContent(@Nonnull List<MultiChatContent> content) {
        this.content = content;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("MultiChatTemplate has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.role != null) {
            declaredFields.put("role", this.role);
        }
        if (this.content != null) {
            declaredFields.put("content", this.content);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiChatTemplate multiChatTemplate = (MultiChatTemplate)o;
        return Objects.equals(this.cloudSdkCustomFields, multiChatTemplate.cloudSdkCustomFields) && Objects.equals(this.role, multiChatTemplate.role) && Objects.equals(this.content, multiChatTemplate.content);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.content, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MultiChatTemplate {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return role -> content -> new MultiChatTemplate().role(role).content(content);
    }

    public static interface Builder {
        public Builder1 role(@Nonnull String var1);
    }

    public static interface Builder1 {
        public MultiChatTemplate content(@Nonnull List<MultiChatContent> var1);

        default public MultiChatTemplate content(MultiChatContent ... content) {
            return this.content(Arrays.asList(content));
        }
    }
}

