/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.GlobalStreamOptions;
import com.sap.ai.sdk.prompt.registry.model.ModuleConfigs;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OrchestrationConfig {
    @JsonProperty(value="modules")
    private ModuleConfigs modules;
    @JsonProperty(value="stream")
    private GlobalStreamOptions stream;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected OrchestrationConfig() {
    }

    @Nonnull
    public OrchestrationConfig modules(@Nonnull ModuleConfigs modules) {
        this.modules = modules;
        return this;
    }

    @Nonnull
    public ModuleConfigs getModules() {
        return this.modules;
    }

    public void setModules(@Nonnull ModuleConfigs modules) {
        this.modules = modules;
    }

    @Nonnull
    public OrchestrationConfig stream(@Nullable GlobalStreamOptions stream) {
        this.stream = stream;
        return this;
    }

    @Nonnull
    public GlobalStreamOptions getStream() {
        return this.stream;
    }

    public void setStream(@Nullable GlobalStreamOptions stream) {
        this.stream = stream;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("OrchestrationConfig has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.modules != null) {
            declaredFields.put("modules", this.modules);
        }
        if (this.stream != null) {
            declaredFields.put("stream", this.stream);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrchestrationConfig orchestrationConfig = (OrchestrationConfig)o;
        return Objects.equals(this.cloudSdkCustomFields, orchestrationConfig.cloudSdkCustomFields) && Objects.equals(this.modules, orchestrationConfig.modules) && Objects.equals(this.stream, orchestrationConfig.stream);
    }

    public int hashCode() {
        return Objects.hash(this.modules, this.stream, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrchestrationConfig {\n");
        sb.append("    modules: ").append(this.toIndentedString(this.modules)).append("\n");
        sb.append("    stream: ").append(this.toIndentedString(this.stream)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return modules -> new OrchestrationConfig().modules(modules);
    }

    public static interface Builder {
        public OrchestrationConfig modules(@Nonnull ModuleConfigs var1);
    }
}

