/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.OrchestrationConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OrchestrationConfigPostRequest {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version;
    @JsonProperty(value="scenario")
    private String scenario;
    @JsonProperty(value="spec")
    private OrchestrationConfig spec;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected OrchestrationConfigPostRequest() {
    }

    @Nonnull
    public OrchestrationConfigPostRequest name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public OrchestrationConfigPostRequest version(@Nonnull String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull String version) {
        this.version = version;
    }

    @Nonnull
    public OrchestrationConfigPostRequest scenario(@Nonnull String scenario) {
        this.scenario = scenario;
        return this;
    }

    @Nonnull
    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(@Nonnull String scenario) {
        this.scenario = scenario;
    }

    @Nonnull
    public OrchestrationConfigPostRequest spec(@Nonnull OrchestrationConfig spec) {
        this.spec = spec;
        return this;
    }

    @Nonnull
    public OrchestrationConfig getSpec() {
        return this.spec;
    }

    public void setSpec(@Nonnull OrchestrationConfig spec) {
        this.spec = spec;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("OrchestrationConfigPostRequest has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.name != null) {
            declaredFields.put("name", this.name);
        }
        if (this.version != null) {
            declaredFields.put("version", this.version);
        }
        if (this.scenario != null) {
            declaredFields.put("scenario", this.scenario);
        }
        if (this.spec != null) {
            declaredFields.put("spec", this.spec);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrchestrationConfigPostRequest orchestrationConfigPostRequest = (OrchestrationConfigPostRequest)o;
        return Objects.equals(this.cloudSdkCustomFields, orchestrationConfigPostRequest.cloudSdkCustomFields) && Objects.equals(this.name, orchestrationConfigPostRequest.name) && Objects.equals(this.version, orchestrationConfigPostRequest.version) && Objects.equals(this.scenario, orchestrationConfigPostRequest.scenario) && Objects.equals(this.spec, orchestrationConfigPostRequest.spec);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.scenario, this.spec, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrchestrationConfigPostRequest {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("    scenario: ").append(this.toIndentedString(this.scenario)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return name -> version -> scenario -> spec -> new OrchestrationConfigPostRequest().name(name).version(version).scenario(scenario).spec(spec);
    }

    public static interface Builder {
        public Builder1 name(@Nonnull String var1);
    }

    public static interface Builder1 {
        public Builder2 version(@Nonnull String var1);
    }

    public static interface Builder2 {
        public Builder3 scenario(@Nonnull String var1);
    }

    public static interface Builder3 {
        public OrchestrationConfigPostRequest spec(@Nonnull OrchestrationConfig var1);
    }
}

