/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OrchestrationConfigPostResponse {
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="scenario")
    private String scenario;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="version")
    private String version;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected OrchestrationConfigPostResponse() {
    }

    @Nonnull
    public OrchestrationConfigPostResponse message(@Nonnull String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nonnull String message) {
        this.message = message;
    }

    @Nonnull
    public OrchestrationConfigPostResponse id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    @Nonnull
    public OrchestrationConfigPostResponse scenario(@Nonnull String scenario) {
        this.scenario = scenario;
        return this;
    }

    @Nonnull
    public String getScenario() {
        return this.scenario;
    }

    public void setScenario(@Nonnull String scenario) {
        this.scenario = scenario;
    }

    @Nonnull
    public OrchestrationConfigPostResponse name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public OrchestrationConfigPostResponse version(@Nonnull String version) {
        this.version = version;
        return this;
    }

    @Nonnull
    public String getVersion() {
        return this.version;
    }

    public void setVersion(@Nonnull String version) {
        this.version = version;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("OrchestrationConfigPostResponse has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.message != null) {
            declaredFields.put("message", this.message);
        }
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        if (this.scenario != null) {
            declaredFields.put("scenario", this.scenario);
        }
        if (this.name != null) {
            declaredFields.put("name", this.name);
        }
        if (this.version != null) {
            declaredFields.put("version", this.version);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrchestrationConfigPostResponse orchestrationConfigPostResponse = (OrchestrationConfigPostResponse)o;
        return Objects.equals(this.cloudSdkCustomFields, orchestrationConfigPostResponse.cloudSdkCustomFields) && Objects.equals(this.message, orchestrationConfigPostResponse.message) && Objects.equals(this.id, orchestrationConfigPostResponse.id) && Objects.equals(this.scenario, orchestrationConfigPostResponse.scenario) && Objects.equals(this.name, orchestrationConfigPostResponse.name) && Objects.equals(this.version, orchestrationConfigPostResponse.version);
    }

    public int hashCode() {
        return Objects.hash(this.message, this.id, this.scenario, this.name, this.version, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrchestrationConfigPostResponse {\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    scenario: ").append(this.toIndentedString(this.scenario)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return message -> id -> scenario -> name -> version -> new OrchestrationConfigPostResponse().message(message).id(id).scenario(scenario).name(name).version(version);
    }

    public static interface Builder {
        public Builder1 message(@Nonnull String var1);
    }

    public static interface Builder1 {
        public Builder2 id(@Nonnull UUID var1);
    }

    public static interface Builder2 {
        public Builder3 scenario(@Nonnull String var1);
    }

    public static interface Builder3 {
        public Builder4 name(@Nonnull String var1);
    }

    public static interface Builder4 {
        public OrchestrationConfigPostResponse version(@Nonnull String var1);
    }
}

