/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.FilteringStreamOptions;
import com.sap.ai.sdk.prompt.registry.model.OutputFilterConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class OutputFilteringConfig {
    @JsonProperty(value="filters")
    private List<OutputFilterConfig> filters = new ArrayList<OutputFilterConfig>();
    @JsonProperty(value="stream_options")
    private FilteringStreamOptions streamOptions;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected OutputFilteringConfig() {
    }

    @Nonnull
    public OutputFilteringConfig filters(@Nonnull List<OutputFilterConfig> filters) {
        this.filters = filters;
        return this;
    }

    @Nonnull
    public OutputFilteringConfig addFiltersItem(@Nonnull OutputFilterConfig filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<OutputFilterConfig>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @Nonnull
    public List<OutputFilterConfig> getFilters() {
        return this.filters;
    }

    public void setFilters(@Nonnull List<OutputFilterConfig> filters) {
        this.filters = filters;
    }

    @Nonnull
    public OutputFilteringConfig streamOptions(@Nullable FilteringStreamOptions streamOptions) {
        this.streamOptions = streamOptions;
        return this;
    }

    @Nonnull
    public FilteringStreamOptions getStreamOptions() {
        return this.streamOptions;
    }

    public void setStreamOptions(@Nullable FilteringStreamOptions streamOptions) {
        this.streamOptions = streamOptions;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("OutputFilteringConfig has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.filters != null) {
            declaredFields.put("filters", this.filters);
        }
        if (this.streamOptions != null) {
            declaredFields.put("streamOptions", this.streamOptions);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OutputFilteringConfig outputFilteringConfig = (OutputFilteringConfig)o;
        return Objects.equals(this.cloudSdkCustomFields, outputFilteringConfig.cloudSdkCustomFields) && Objects.equals(this.filters, outputFilteringConfig.filters) && Objects.equals(this.streamOptions, outputFilteringConfig.streamOptions);
    }

    public int hashCode() {
        return Objects.hash(this.filters, this.streamOptions, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OutputFilteringConfig {\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        sb.append("    streamOptions: ").append(this.toIndentedString(this.streamOptions)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return filters -> new OutputFilteringConfig().filters(filters);
    }

    public static interface Builder {
        public OutputFilteringConfig filters(@Nonnull List<OutputFilterConfig> var1);

        default public OutputFilteringConfig filters(OutputFilterConfig ... filters) {
            return this.filters(Arrays.asList(filters));
        }
    }
}

