/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.ChatCompletionTool;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplate;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplateSpecResponseFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PromptTemplateSpec {
    @JsonProperty(value="template")
    private List<PromptTemplate> template = new ArrayList<PromptTemplate>();
    @JsonProperty(value="defaults")
    private Object defaults;
    @JsonProperty(value="additionalFields")
    private Object additionalFields;
    @JsonProperty(value="response_format")
    private PromptTemplateSpecResponseFormat responseFormat;
    @JsonProperty(value="tools")
    private List<ChatCompletionTool> tools = new ArrayList<ChatCompletionTool>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected PromptTemplateSpec() {
    }

    @Nonnull
    public PromptTemplateSpec template(@Nonnull List<PromptTemplate> template) {
        this.template = template;
        return this;
    }

    @Nonnull
    public PromptTemplateSpec addTemplateItem(@Nonnull PromptTemplate templateItem) {
        if (this.template == null) {
            this.template = new ArrayList<PromptTemplate>();
        }
        this.template.add(templateItem);
        return this;
    }

    @Nonnull
    public List<PromptTemplate> getTemplate() {
        return this.template;
    }

    public void setTemplate(@Nonnull List<PromptTemplate> template) {
        this.template = template;
    }

    @Nonnull
    public PromptTemplateSpec defaults(@Nullable Object defaults) {
        this.defaults = defaults;
        return this;
    }

    @Nonnull
    public Object getDefaults() {
        return this.defaults;
    }

    public void setDefaults(@Nullable Object defaults) {
        this.defaults = defaults;
    }

    @Nonnull
    public PromptTemplateSpec additionalFields(@Nullable Object additionalFields) {
        this.additionalFields = additionalFields;
        return this;
    }

    @Deprecated
    @Nonnull
    public Object getAdditionalFields() {
        return this.additionalFields;
    }

    public void setAdditionalFields(@Nullable Object additionalFields) {
        this.additionalFields = additionalFields;
    }

    @Nonnull
    public PromptTemplateSpec responseFormat(@Nullable PromptTemplateSpecResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    @Nonnull
    public PromptTemplateSpecResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(@Nullable PromptTemplateSpecResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @Nonnull
    public PromptTemplateSpec tools(@Nullable List<ChatCompletionTool> tools) {
        this.tools = tools;
        return this;
    }

    @Nonnull
    public PromptTemplateSpec addToolsItem(@Nonnull ChatCompletionTool toolsItem) {
        if (this.tools == null) {
            this.tools = new ArrayList<ChatCompletionTool>();
        }
        this.tools.add(toolsItem);
        return this;
    }

    @Nonnull
    public List<ChatCompletionTool> getTools() {
        return this.tools;
    }

    public void setTools(@Nullable List<ChatCompletionTool> tools) {
        this.tools = tools;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("PromptTemplateSpec has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.template != null) {
            declaredFields.put("template", this.template);
        }
        if (this.defaults != null) {
            declaredFields.put("defaults", this.defaults);
        }
        if (this.additionalFields != null) {
            declaredFields.put("additionalFields", this.additionalFields);
        }
        if (this.responseFormat != null) {
            declaredFields.put("responseFormat", this.responseFormat);
        }
        if (this.tools != null) {
            declaredFields.put("tools", this.tools);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PromptTemplateSpec promptTemplateSpec = (PromptTemplateSpec)o;
        return Objects.equals(this.cloudSdkCustomFields, promptTemplateSpec.cloudSdkCustomFields) && Objects.equals(this.template, promptTemplateSpec.template) && Objects.equals(this.defaults, promptTemplateSpec.defaults) && Objects.equals(this.additionalFields, promptTemplateSpec.additionalFields) && Objects.equals(this.responseFormat, promptTemplateSpec.responseFormat) && Objects.equals(this.tools, promptTemplateSpec.tools);
    }

    public int hashCode() {
        return Objects.hash(this.template, this.defaults, this.additionalFields, this.responseFormat, this.tools, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PromptTemplateSpec {\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    defaults: ").append(this.toIndentedString(this.defaults)).append("\n");
        sb.append("    additionalFields: ").append(this.toIndentedString(this.additionalFields)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString(this.responseFormat)).append("\n");
        sb.append("    tools: ").append(this.toIndentedString(this.tools)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return template -> new PromptTemplateSpec().template(template);
    }

    public static interface Builder {
        public PromptTemplateSpec template(@Nonnull List<PromptTemplate> var1);

        default public PromptTemplateSpec template(PromptTemplate ... template) {
            return this.template(Arrays.asList(template));
        }
    }
}

