/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.LLMModelDetails;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplatingModuleConfigPrompt;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PromptTemplatingModuleConfig {
    @JsonProperty(value="prompt")
    private PromptTemplatingModuleConfigPrompt prompt;
    @JsonProperty(value="model")
    private LLMModelDetails model;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected PromptTemplatingModuleConfig() {
    }

    @Nonnull
    public PromptTemplatingModuleConfig prompt(@Nonnull PromptTemplatingModuleConfigPrompt prompt) {
        this.prompt = prompt;
        return this;
    }

    @Nonnull
    public PromptTemplatingModuleConfigPrompt getPrompt() {
        return this.prompt;
    }

    public void setPrompt(@Nonnull PromptTemplatingModuleConfigPrompt prompt) {
        this.prompt = prompt;
    }

    @Nonnull
    public PromptTemplatingModuleConfig model(@Nonnull LLMModelDetails model) {
        this.model = model;
        return this;
    }

    @Nonnull
    public LLMModelDetails getModel() {
        return this.model;
    }

    public void setModel(@Nonnull LLMModelDetails model) {
        this.model = model;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("PromptTemplatingModuleConfig has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.prompt != null) {
            declaredFields.put("prompt", this.prompt);
        }
        if (this.model != null) {
            declaredFields.put("model", this.model);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PromptTemplatingModuleConfig promptTemplatingModuleConfig = (PromptTemplatingModuleConfig)o;
        return Objects.equals(this.cloudSdkCustomFields, promptTemplatingModuleConfig.cloudSdkCustomFields) && Objects.equals(this.prompt, promptTemplatingModuleConfig.prompt) && Objects.equals(this.model, promptTemplatingModuleConfig.model);
    }

    public int hashCode() {
        return Objects.hash(this.prompt, this.model, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PromptTemplatingModuleConfig {\n");
        sb.append("    prompt: ").append(this.toIndentedString(this.prompt)).append("\n");
        sb.append("    model: ").append(this.toIndentedString(this.model)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return prompt -> model -> new PromptTemplatingModuleConfig().prompt(prompt).model(model);
    }

    public static interface Builder {
        public Builder1 prompt(@Nonnull PromptTemplatingModuleConfigPrompt var1);
    }

    public static interface Builder1 {
        public PromptTemplatingModuleConfig model(@Nonnull LLMModelDetails var1);
    }
}

