/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplateSpec;
import com.sap.ai.sdk.prompt.registry.model.RuntimePromptTemplateFileMetadata;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RuntimePromptTemplateFile {
    @JsonProperty(value="apiVersion")
    private String apiVersion;
    @JsonProperty(value="kind")
    private String kind;
    @JsonProperty(value="metadata")
    private RuntimePromptTemplateFileMetadata metadata;
    @JsonProperty(value="spec")
    private PromptTemplateSpec spec;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected RuntimePromptTemplateFile() {
    }

    @Nonnull
    public RuntimePromptTemplateFile apiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    @Nonnull
    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(@Nullable String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @Nonnull
    public RuntimePromptTemplateFile kind(@Nullable String kind) {
        this.kind = kind;
        return this;
    }

    @Nonnull
    public String getKind() {
        return this.kind;
    }

    public void setKind(@Nullable String kind) {
        this.kind = kind;
    }

    @Nonnull
    public RuntimePromptTemplateFile metadata(@Nullable RuntimePromptTemplateFileMetadata metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public RuntimePromptTemplateFileMetadata getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable RuntimePromptTemplateFileMetadata metadata) {
        this.metadata = metadata;
    }

    @Nonnull
    public RuntimePromptTemplateFile spec(@Nullable PromptTemplateSpec spec) {
        this.spec = spec;
        return this;
    }

    @Nonnull
    public PromptTemplateSpec getSpec() {
        return this.spec;
    }

    public void setSpec(@Nullable PromptTemplateSpec spec) {
        this.spec = spec;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("RuntimePromptTemplateFile has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.apiVersion != null) {
            declaredFields.put("apiVersion", this.apiVersion);
        }
        if (this.kind != null) {
            declaredFields.put("kind", this.kind);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        if (this.spec != null) {
            declaredFields.put("spec", this.spec);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimePromptTemplateFile runtimePromptTemplateFile = (RuntimePromptTemplateFile)o;
        return Objects.equals(this.cloudSdkCustomFields, runtimePromptTemplateFile.cloudSdkCustomFields) && Objects.equals(this.apiVersion, runtimePromptTemplateFile.apiVersion) && Objects.equals(this.kind, runtimePromptTemplateFile.kind) && Objects.equals(this.metadata, runtimePromptTemplateFile.metadata) && Objects.equals(this.spec, runtimePromptTemplateFile.spec);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RuntimePromptTemplateFile {\n");
        sb.append("    apiVersion: ").append(this.toIndentedString(this.apiVersion)).append("\n");
        sb.append("    kind: ").append(this.toIndentedString(this.kind)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static RuntimePromptTemplateFile create() {
        return new RuntimePromptTemplateFile();
    }
}

