/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SAPDocumentTranslationConfig {
    @JsonProperty(value="source_language")
    private String sourceLanguage;
    @JsonProperty(value="target_language")
    private String targetLanguage;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected SAPDocumentTranslationConfig() {
    }

    @Nonnull
    public SAPDocumentTranslationConfig sourceLanguage(@Nullable String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
        return this;
    }

    @Nonnull
    public String getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(@Nullable String sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    @Nonnull
    public SAPDocumentTranslationConfig targetLanguage(@Nonnull String targetLanguage) {
        this.targetLanguage = targetLanguage;
        return this;
    }

    @Nonnull
    public String getTargetLanguage() {
        return this.targetLanguage;
    }

    public void setTargetLanguage(@Nonnull String targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("SAPDocumentTranslationConfig has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.sourceLanguage != null) {
            declaredFields.put("sourceLanguage", this.sourceLanguage);
        }
        if (this.targetLanguage != null) {
            declaredFields.put("targetLanguage", this.targetLanguage);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAPDocumentTranslationConfig saPDocumentTranslationConfig = (SAPDocumentTranslationConfig)o;
        return Objects.equals(this.cloudSdkCustomFields, saPDocumentTranslationConfig.cloudSdkCustomFields) && Objects.equals(this.sourceLanguage, saPDocumentTranslationConfig.sourceLanguage) && Objects.equals(this.targetLanguage, saPDocumentTranslationConfig.targetLanguage);
    }

    public int hashCode() {
        return Objects.hash(this.sourceLanguage, this.targetLanguage, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SAPDocumentTranslationConfig {\n");
        sb.append("    sourceLanguage: ").append(this.toIndentedString(this.sourceLanguage)).append("\n");
        sb.append("    targetLanguage: ").append(this.toIndentedString(this.targetLanguage)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return targetLanguage -> new SAPDocumentTranslationConfig().targetLanguage(targetLanguage);
    }

    public static interface Builder {
        public SAPDocumentTranslationConfig targetLanguage(@Nonnull String var1);
    }
}

