/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplate;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SingleChatTemplate
implements PromptTemplate {
    @JsonProperty(value="role")
    private String role;
    @JsonProperty(value="content")
    private String content;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected SingleChatTemplate() {
    }

    @Nonnull
    public SingleChatTemplate role(@Nonnull String role) {
        this.role = role;
        return this;
    }

    @Nonnull
    public String getRole() {
        return this.role;
    }

    public void setRole(@Nonnull String role) {
        this.role = role;
    }

    @Nonnull
    public SingleChatTemplate content(@Nonnull String content) {
        this.content = content;
        return this;
    }

    @Nonnull
    public String getContent() {
        return this.content;
    }

    public void setContent(@Nonnull String content) {
        this.content = content;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("SingleChatTemplate has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.role != null) {
            declaredFields.put("role", this.role);
        }
        if (this.content != null) {
            declaredFields.put("content", this.content);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleChatTemplate singleChatTemplate = (SingleChatTemplate)o;
        return Objects.equals(this.cloudSdkCustomFields, singleChatTemplate.cloudSdkCustomFields) && Objects.equals(this.role, singleChatTemplate.role) && Objects.equals(this.content, singleChatTemplate.content);
    }

    public int hashCode() {
        return Objects.hash(this.role, this.content, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SingleChatTemplate {\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return role -> content -> new SingleChatTemplate().role(role).content(content);
    }

    public static interface Builder {
        public Builder1 role(@Nonnull String var1);
    }

    public static interface Builder1 {
        public SingleChatTemplate content(@Nonnull String var1);
    }
}

