/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.ChatCompletionTool;
import com.sap.ai.sdk.prompt.registry.model.ChatMessage;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplatingModuleConfigPrompt;
import com.sap.ai.sdk.prompt.registry.model.TemplateResponseFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Template
implements PromptTemplatingModuleConfigPrompt {
    @JsonProperty(value="template")
    private List<ChatMessage> template;
    @JsonProperty(value="defaults")
    private Map<String, String> defaults = new HashMap<String, String>();
    @JsonProperty(value="response_format")
    private TemplateResponseFormat responseFormat;
    @JsonProperty(value="tools")
    private List<ChatCompletionTool> tools = new ArrayList<ChatCompletionTool>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected Template() {
    }

    @Nonnull
    public Template template(@Nonnull List<ChatMessage> template) {
        this.template = template;
        return this;
    }

    @Nonnull
    public Template addTemplateItem(@Nonnull ChatMessage templateItem) {
        if (this.template == null) {
            this.template = new ArrayList<ChatMessage>();
        }
        this.template.add(templateItem);
        return this;
    }

    @Nonnull
    public List<ChatMessage> getTemplate() {
        return this.template;
    }

    public void setTemplate(@Nonnull List<ChatMessage> template) {
        this.template = template;
    }

    @Nonnull
    public Template defaults(@Nullable Map<String, String> defaults) {
        this.defaults = defaults;
        return this;
    }

    @Nonnull
    public Template putdefaultsItem(@Nonnull String key, @Nonnull String defaultsItem) {
        if (this.defaults == null) {
            this.defaults = new HashMap<String, String>();
        }
        this.defaults.put(key, defaultsItem);
        return this;
    }

    @Nonnull
    public Map<String, String> getDefaults() {
        return this.defaults;
    }

    public void setDefaults(@Nullable Map<String, String> defaults) {
        this.defaults = defaults;
    }

    @Nonnull
    public Template responseFormat(@Nullable TemplateResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    @Nonnull
    public TemplateResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    public void setResponseFormat(@Nullable TemplateResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
    }

    @Nonnull
    public Template tools(@Nullable List<ChatCompletionTool> tools) {
        this.tools = tools;
        return this;
    }

    @Nonnull
    public Template addToolsItem(@Nonnull ChatCompletionTool toolsItem) {
        if (this.tools == null) {
            this.tools = new ArrayList<ChatCompletionTool>();
        }
        this.tools.add(toolsItem);
        return this;
    }

    @Nonnull
    public List<ChatCompletionTool> getTools() {
        return this.tools;
    }

    public void setTools(@Nullable List<ChatCompletionTool> tools) {
        this.tools = tools;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("Template has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.template != null) {
            declaredFields.put("template", this.template);
        }
        if (this.defaults != null) {
            declaredFields.put("defaults", this.defaults);
        }
        if (this.responseFormat != null) {
            declaredFields.put("responseFormat", this.responseFormat);
        }
        if (this.tools != null) {
            declaredFields.put("tools", this.tools);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Template template = (Template)o;
        return Objects.equals(this.cloudSdkCustomFields, template.cloudSdkCustomFields) && Objects.equals(this.template, template.template) && Objects.equals(this.defaults, template.defaults) && Objects.equals(this.responseFormat, template.responseFormat) && Objects.equals(this.tools, template.tools);
    }

    public int hashCode() {
        return Objects.hash(this.template, this.defaults, this.responseFormat, this.tools, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Template {\n");
        sb.append("    template: ").append(this.toIndentedString(this.template)).append("\n");
        sb.append("    defaults: ").append(this.toIndentedString(this.defaults)).append("\n");
        sb.append("    responseFormat: ").append(this.toIndentedString(this.responseFormat)).append("\n");
        sb.append("    tools: ").append(this.toIndentedString(this.tools)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return template -> new Template().template(template);
    }

    public static interface Builder {
        public Template template(@Nonnull List<ChatMessage> var1);

        default public Template template(ChatMessage ... template) {
            return this.template(Arrays.asList(template));
        }
    }
}

