/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sap.ai.sdk.prompt.registry.model.ChatMessage;
import com.sap.ai.sdk.prompt.registry.model.ChatMessageContent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ToolChatMessage
implements ChatMessage {
    @JsonProperty(value="role")
    private RoleEnum role;
    @JsonProperty(value="tool_call_id")
    private String toolCallId;
    @JsonProperty(value="content")
    private ChatMessageContent content;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected ToolChatMessage() {
    }

    @Nonnull
    public ToolChatMessage role(@Nonnull RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nonnull
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(@Nonnull RoleEnum role) {
        this.role = role;
    }

    @Nonnull
    public ToolChatMessage toolCallId(@Nonnull String toolCallId) {
        this.toolCallId = toolCallId;
        return this;
    }

    @Nonnull
    public String getToolCallId() {
        return this.toolCallId;
    }

    public void setToolCallId(@Nonnull String toolCallId) {
        this.toolCallId = toolCallId;
    }

    @Nonnull
    public ToolChatMessage content(@Nonnull ChatMessageContent content) {
        this.content = content;
        return this;
    }

    @Nonnull
    public ChatMessageContent getContent() {
        return this.content;
    }

    public void setContent(@Nonnull ChatMessageContent content) {
        this.content = content;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("ToolChatMessage has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.role != null) {
            declaredFields.put("role", (Object)this.role);
        }
        if (this.toolCallId != null) {
            declaredFields.put("toolCallId", this.toolCallId);
        }
        if (this.content != null) {
            declaredFields.put("content", this.content);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ToolChatMessage toolChatMessage = (ToolChatMessage)o;
        return Objects.equals(this.cloudSdkCustomFields, toolChatMessage.cloudSdkCustomFields) && Objects.equals((Object)this.role, (Object)toolChatMessage.role) && Objects.equals(this.toolCallId, toolChatMessage.toolCallId) && Objects.equals(this.content, toolChatMessage.content);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.role, this.toolCallId, this.content, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ToolChatMessage {\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        sb.append("    toolCallId: ").append(this.toIndentedString(this.toolCallId)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return role -> toolCallId -> content -> new ToolChatMessage().role(role).toolCallId(toolCallId).content(content);
    }

    public static enum RoleEnum {
        TOOL("tool"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static RoleEnum fromValue(@Nonnull String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static interface Builder {
        public Builder1 role(@Nonnull RoleEnum var1);
    }

    public static interface Builder1 {
        public Builder2 toolCallId(@Nonnull String var1);
    }

    public static interface Builder2 {
        public ToolChatMessage content(@Nonnull ChatMessageContent var1);
    }
}

