/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.prompt.registry.model.SAPDocumentTranslation;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TranslationModuleConfig {
    @JsonProperty(value="input")
    private SAPDocumentTranslation input;
    @JsonProperty(value="output")
    private SAPDocumentTranslation output;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected TranslationModuleConfig() {
    }

    @Nonnull
    public TranslationModuleConfig input(@Nullable SAPDocumentTranslation input) {
        this.input = input;
        return this;
    }

    @Nonnull
    public SAPDocumentTranslation getInput() {
        return this.input;
    }

    public void setInput(@Nullable SAPDocumentTranslation input) {
        this.input = input;
    }

    @Nonnull
    public TranslationModuleConfig output(@Nullable SAPDocumentTranslation output) {
        this.output = output;
        return this;
    }

    @Nonnull
    public SAPDocumentTranslation getOutput() {
        return this.output;
    }

    public void setOutput(@Nullable SAPDocumentTranslation output) {
        this.output = output;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("TranslationModuleConfig has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.input != null) {
            declaredFields.put("input", this.input);
        }
        if (this.output != null) {
            declaredFields.put("output", this.output);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslationModuleConfig translationModuleConfig = (TranslationModuleConfig)o;
        return Objects.equals(this.cloudSdkCustomFields, translationModuleConfig.cloudSdkCustomFields) && Objects.equals(this.input, translationModuleConfig.input) && Objects.equals(this.output, translationModuleConfig.output);
    }

    public int hashCode() {
        return Objects.hash(this.input, this.output, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TranslationModuleConfig {\n");
        sb.append("    input: ").append(this.toIndentedString(this.input)).append("\n");
        sb.append("    output: ").append(this.toIndentedString(this.output)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static TranslationModuleConfig create() {
        return new TranslationModuleConfig();
    }
}

