/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sap.ai.sdk.prompt.registry.model.ChatMessage;
import com.sap.ai.sdk.prompt.registry.model.UserChatMessageContent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserChatMessage
implements ChatMessage {
    @JsonProperty(value="content")
    private UserChatMessageContent content;
    @JsonProperty(value="role")
    private RoleEnum role;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected UserChatMessage() {
    }

    @Nonnull
    public UserChatMessage content(@Nonnull UserChatMessageContent content) {
        this.content = content;
        return this;
    }

    @Nonnull
    public UserChatMessageContent getContent() {
        return this.content;
    }

    public void setContent(@Nonnull UserChatMessageContent content) {
        this.content = content;
    }

    @Nonnull
    public UserChatMessage role(@Nonnull RoleEnum role) {
        this.role = role;
        return this;
    }

    @Nonnull
    public RoleEnum getRole() {
        return this.role;
    }

    public void setRole(@Nonnull RoleEnum role) {
        this.role = role;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("UserChatMessage has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.content != null) {
            declaredFields.put("content", this.content);
        }
        if (this.role != null) {
            declaredFields.put("role", (Object)this.role);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserChatMessage userChatMessage = (UserChatMessage)o;
        return Objects.equals(this.cloudSdkCustomFields, userChatMessage.cloudSdkCustomFields) && Objects.equals(this.content, userChatMessage.content) && Objects.equals((Object)this.role, (Object)userChatMessage.role);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.content, this.role, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserChatMessage {\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    role: ").append(this.toIndentedString((Object)this.role)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return content -> role -> new UserChatMessage().content(content).role(role);
    }

    public static enum RoleEnum {
        USER("user"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static RoleEnum fromValue(@Nonnull String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static interface Builder {
        public Builder1 content(@Nonnull UserChatMessageContent var1);
    }

    public static interface Builder1 {
        public UserChatMessage role(@Nonnull RoleEnum var1);
    }
}

