/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.prompt.registry.spring;

import com.sap.ai.sdk.prompt.registry.model.PromptTemplate;
import com.sap.ai.sdk.prompt.registry.model.PromptTemplateSubstitutionResponse;
import com.sap.ai.sdk.prompt.registry.model.SingleChatTemplate;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.UserMessage;

public class SpringAiConverter {
    private SpringAiConverter() {
    }

    @Nonnull
    public static List<Message> promptTemplateToMessages(@Nonnull PromptTemplateSubstitutionResponse promptResponse) {
        List<PromptTemplate> res = promptResponse.getParsedPrompt();
        return res.stream().map(t -> {
            SingleChatTemplate message = (SingleChatTemplate)t;
            return switch (message.getRole()) {
                case "system" -> new SystemMessage(message.getContent());
                case "user" -> new UserMessage(message.getContent());
                case "assistant" -> new AssistantMessage(message.getContent());
                default -> throw new IllegalArgumentException("Unknown role: " + message.getRole());
            };
        }).toList();
    }
}

