/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.reflect.CdsModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Stream;

public class ServletUrlResourcePaths {
    private List<UrlResourcePath> servletPaths = new ArrayList<UrlResourcePath>();

    public ServletUrlResourcePaths(CdsModel cdsModel) {
        Objects.requireNonNull(cdsModel, "cdsModel is required to find public cds endpoints");
        ServiceLoader<AdapterFactory> factoryIterator = ServiceLoader.load(AdapterFactory.class);
        factoryIterator.iterator().forEachRemaining(factory -> {
            ServletAdapterFactory servletFactory;
            if (factory instanceof ServletAdapterFactory && (servletFactory = (ServletAdapterFactory)factory).isEnabled()) {
                UrlResourcePath servletPath = servletFactory.getServletPath(cdsModel);
                this.servletPaths.add(servletPath);
            }
        });
    }

    public Stream<UrlResourcePath> getBasePaths() {
        return this.servletPaths.stream();
    }

    public void visit(UrlResourcePathVisitor visitor) {
        Objects.requireNonNull(visitor, "visitor is required to handle public endpoints");
        this.servletPaths.forEach(p -> this.visitServletPath((UrlResourcePath)p, visitor));
    }

    private void visitServletPath(UrlResourcePath servletPath, UrlResourcePathVisitor visitor) {
        servletPath.subPaths().forEach(subPath -> this.visitServletPath((UrlResourcePath)subPath, visitor));
        if (servletPath.isPublic()) {
            visitor.foundPublicPath(servletPath);
        } else {
            visitor.foundPublicEvents(servletPath, servletPath.publicEvents());
        }
    }

    public static interface UrlResourcePathVisitor {
        public void foundPublicPath(UrlResourcePath var1);

        public void foundPublicEvents(UrlResourcePath var1, Stream<String> var2);
    }
}

