/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter;

import java.util.stream.Stream;

import javax.servlet.Servlet;

import com.sap.cds.services.runtime.CdsRuntime;

/**
 * Specialized factory for creating Servlet adapters
 */
public interface ServletAdapterFactory extends AdapterFactory {

	/**
	 * Returns the adapter servlet, initialized with the {@link CdsRuntime}
	 * @param runtime the {@link CdsRuntime}
	 * @return the adapter servlet
	 */
	@Override
	Servlet createAdapter(CdsRuntime runtime);

	/**
	 * @return the common base path of the servlet
	 */
	String getBasePath();

	/**
	 * Returns an array of all paths this servlet should be mapped to.
	 * Recursive paths are given as <code>/**</code>.
	 * In the standard servlet API these are usually given only as <code>/*</code>.
	 *
	 * @param runtime The {@link CdsRuntime}
	 * @return an array of all path mappings
	 */
	String[] getMappings(CdsRuntime runtime);

	/**
	 * Returns the {@link Stream} of {@link UrlResourcePath}s that are exposed by the servlet.
	 *
	 * @param runtime	The {@link CdsRuntime}.
	 * @return	The {@link UrlResourcePath}s
	 */
	UrlResourcePath getServletPath(CdsRuntime runtime);
}
