/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter;

import com.sap.cds.services.runtime.CdsRuntime;

/**
 * Interface to use Java's ServiceLoader for creating adapters
 */
public interface AdapterFactory {

	/**
	 * Creates the adapter and initializes it with the {@link CdsRuntime}
	 * @param runtime the {@link CdsRuntime}
	 * @return the created adapter
	 */
	Object createAdapter(CdsRuntime runtime);

	/**
	 * @return true, if the adapter is enabled
	 */
	boolean isEnabled();

}