/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter;

import com.sap.cds.services.runtime.CdsRuntime;

/**
 * Interface to use Java's ServiceLoader for creating content providers for the index page
 */
public interface IndexContentProviderFactory {

	/**
	 * Creates the content provider and initializes it with the {@link CdsRuntime}
	 * @param runtime the {@link CdsRuntime}
	 * @return the created adapter
	 */
	IndexContentProvider createContentProvider(CdsRuntime runtime);

	/**
	 * @return true, if the content provider is enabled
	 */
	boolean isEnabled();

}