/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.ExtendedServiceLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class ServletUrlResourcePaths {
    private List<UrlResourcePath> servletPaths = new ArrayList<UrlResourcePath>();

    public ServletUrlResourcePaths(CdsRuntime runtime) {
        Objects.requireNonNull(runtime, "runtime must not be null");
        Iterator factoryIterator = ExtendedServiceLoader.loadAll(AdapterFactory.class, (CdsRuntime)runtime);
        factoryIterator.forEachRemaining(factory -> {
            ServletAdapterFactory servletFactory;
            if (factory instanceof ServletAdapterFactory && (servletFactory = (ServletAdapterFactory)factory).isEnabled()) {
                UrlResourcePath servletPath = servletFactory.getServletPath();
                this.servletPaths.add(servletPath);
            }
        });
        Collections.sort(this.servletPaths, (p1, p2) -> {
            int comparison = -1 * Integer.compare(this.countSegments((UrlResourcePath)p1), this.countSegments((UrlResourcePath)p2));
            if (comparison == 0) {
                if (p1.getPath().startsWith(p2.getPath())) {
                    return 1;
                }
                if (p2.getPath().startsWith(p1.getPath())) {
                    return -1;
                }
            }
            return comparison;
        });
    }

    public Stream<UrlResourcePath> getBasePaths() {
        return this.servletPaths.stream();
    }

    public void visit(UrlResourcePathVisitor visitor) {
        Objects.requireNonNull(visitor, "visitor is required to handle public endpoints");
        this.servletPaths.forEach(p -> this.visitServletPath((UrlResourcePath)p, visitor));
    }

    private void visitServletPath(UrlResourcePath servletPath, UrlResourcePathVisitor visitor) {
        servletPath.subPaths().forEach(subPath -> this.visitServletPath((UrlResourcePath)subPath, visitor));
        if (servletPath.isPublic()) {
            visitor.foundPublicPath(servletPath);
        } else {
            visitor.foundPublicEvents(servletPath, servletPath.publicEvents());
        }
    }

    private int countSegments(UrlResourcePath path) {
        int count = 0;
        for (char c : path.getPath().toCharArray()) {
            if (c != '/') continue;
            ++count;
        }
        return count;
    }

    public static interface UrlResourcePathVisitor {
        public void foundPublicPath(UrlResourcePath var1);

        public void foundPublicEvents(UrlResourcePath var1, Stream<String> var2);
    }
}

