/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.runtime.ExtendedServiceLoader;

/**
 * Interface to be used with {@link ExtendedServiceLoader} for creating adapters.
 * Implementing classes can get access to the {@link CdsRuntime} by implementing {@link CdsRuntimeAware}.
 */
public interface AdapterFactory {

	/**
	 * Creates the adapter and initializes it
	 * @return the created adapter
	 */
	Object create();

	/**
	 * @return true, if the adapter is enabled
	 */
	boolean isEnabled();

}
