/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;
import com.sap.cds.services.runtime.ExtendedServiceLoader;

/**
 * Interface to be used with {@link ExtendedServiceLoader} for creating content providers for the index page.
 * Implementing classes can get access to the {@link CdsRuntime} by implementing {@link CdsRuntimeAware}.
 */
public interface IndexContentProviderFactory {

	/**
	 * Creates the content provider and initializes it
	 * @return the created content provider
	 */
	IndexContentProvider create();

	/**
	 * @return true, if the content provider is enabled
	 */
	boolean isEnabled();

}
