/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter;

import java.util.stream.Stream;

/**
 * A {@link UrlResourcePath} describes the hierarchical structure of a resource along with additional meta information.
 */
public interface UrlResourcePath {

	/**
	 * The path including the resource's base path. Ant patterns to specify collections of endpoints are allowed.
	 *
	 * @return	The path of the resource endpoint
	 */
	String getPath();

	/**
	 * If {@code true}, the endpoint should be exposed to public, i.e. without authentication
	 *
	 * @return {@code true} if public
	 */
	boolean isPublic();

	/**
	 * A {@link Stream} of events that are public even if {@code isPublic()==false}.
	 *
	 * @return The stream of public events
	 */
	Stream<String> publicEvents();

	/**
	 * A {@link Stream} of child paths.
	 *
	 * @return	The child ResourcePaths
	 */
	Stream<UrlResourcePath> subPaths();
}
