package com.sap.cds.adapter.edmx;

import java.util.Locale;
import java.util.Map;

import com.sap.cds.services.runtime.CdsProvider;

/**
 * An {@link EdmxI18nProvider} provides translatable texts for metadata documents.
 */
public interface EdmxI18nProvider extends CdsProvider<EdmxI18nProvider> {

	/**
	 * Provides the ETag of the translatable texts for a given locale.
	 *
	 * @param locale the locale
	 * @return the ETag of the translatable texts in the respective locale.
	 */
	public String getETag(Locale locale);

	/**
	 * Provides the translatable texts for a given locale.
	 *
	 * @param locale the locale
	 * @return the i18n keys mapped to the texts in the respective locale.
	 */
	public Map<String, String> getTexts(Locale locale);

}
