/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter;

import java.util.stream.Stream;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;

/**
 * Specialized factory for creating Servlet adapters.
 * Implementing classes can get access to the {@link CdsRuntime} by implementing {@link CdsRuntimeAware}.
 */
public interface ServletAdapterFactory extends AdapterFactory {

	/**
	 * @return the common base path of the servlet
	 */
	String getBasePath();

	/**
	 * Returns an array of all paths this servlet should be mapped to.
	 * Recursive paths are given as <code>/**</code>.
	 * In the standard servlet API these are usually given only as <code>/*</code>.
	 *
	 * @return an array of all path mappings
	 */
	String[] getMappings();

	/**
	 * Returns the {@link Stream} of {@link UrlResourcePath}s that are exposed by the servlet.
	 *
	 * @return	The {@link UrlResourcePath}s
	 */
	UrlResourcePath getServletPath();
}
