/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter;

import java.io.PrintWriter;

/**
 * Interface to implement by content providers for the index page
 */
public interface IndexContentProvider {

	/**
	 * @return the text to use as title for the index page section of this provide
	 */
	String getSectionTitle();

	/**
	 * Write the index page content
	 *
	 * @param out the writer to output the content to
	 * @param contextPath the servlet context path
	 */
	void writeContent(PrintWriter out, String contextPath);

	/**
	 * The order can be used to list index content in a specified order.
	 * The default order is 0. Index content with a lower order is shown before index content with a higher order.
	 *
	 * @return the order value
	 */
	default int order() {
		return 0;
	}

}
