/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.edmx;

import java.io.InputStream;

/**
 * An {@link EdmxProvider} provides EDMX metadata documents to the OData adapters.
 */
public interface EdmxProvider {

	/**
	 * Provides the ETag of the EDMX metadata document for the given service.
	 *
	 * @param serviceName the name of the service
	 * @return the ETag of the EDMX metadata document
	 */
	String getETag(String serviceName);

	/**
	 * Provides the EDMX metadata document for the given service as an {@link InputStream}.
	 *
	 * @param serviceName the name of the service
	 * @return the EDMX metadata document
	 */
	InputStream getEdmx(String serviceName);

}
