/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2;

import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.adapter.odata.v2.metadata.mtx.AbstractEdmxProviderAccessor;
import com.sap.cds.adapter.odata.v2.processors.ErrorCallback;
import com.sap.cds.adapter.odata.v2.processors.OlingoProcessor;
import com.sap.cds.feature.localization.DefaultLocalizedMessageProvider;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.ODataUtils;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.path.CdsServicePath;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsODataV2ServiceFactory
extends ODataServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(CdsODataV2ServiceFactory.class);
    private static final String METADATA_URL = "$metadata";
    private static final String PATHINFO = "~pathInfo";
    private final Map<String, ApplicationService> servicePaths;

    public CdsODataV2ServiceFactory(CdsRuntime runtime) {
        ServiceCatalog serviceCatalog = runtime.getServiceCatalog();
        this.servicePaths = CdsServicePath.basePaths((ServiceCatalog)serviceCatalog, (String)"odata-v2");
        AbstractEdmxProviderAccessor.initialize(runtime);
    }

    public ODataService createService(ODataContext context) throws ODataException {
        HttpServletRequest request = (HttpServletRequest)context.getParameter("~httpRequestObject");
        CdsRequestGlobals requestGlobals = (CdsRequestGlobals)request.getAttribute("requestGlobals");
        try {
            PathInfo path = (PathInfo)context.getParameter(PATHINFO);
            String pathInfo = path.getRequestUri().getPath();
            if (pathInfo == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_URI_RESOURCE, new Object[0]);
            }
            MutablePair<ApplicationService, String> serviceInfo = this.extractServiceInfo(request.getPathInfo(), this.servicePaths);
            ApplicationService applicationService = (ApplicationService)serviceInfo.getLeft();
            String serviceName = applicationService.getDefinition().getQualifiedName();
            requestGlobals.setApplicationService(applicationService);
            applicationService.getDefinition().entities().forEach(entity -> {
                String cdsName = entity.getName();
                String edmName = ODataUtils.toODataName((String)cdsName);
                if (!edmName.equals(cdsName)) {
                    String key = entity.getQualifier() + "." + edmName;
                    String value = entity.getQualifier() + "." + cdsName;
                    requestGlobals.getCdsEntityNames().put(key, value);
                }
            });
            ODataV2EdmProvider edm = null;
            String etag = null;
            AbstractEdmxProviderAccessor accessor = AbstractEdmxProviderAccessor.getInstance();
            Locale locale = CdsRequestGlobals.currentContext().getParameterInfo().getLocale();
            if (pathInfo.endsWith(METADATA_URL) && locale != null) {
                String language = DefaultLocalizedMessageProvider.getLocaleForBundle((Locale)locale).toString();
                String localizedServiceName = serviceName + "_" + language;
                edm = accessor.getEdmxMetadataProvider(localizedServiceName);
                etag = accessor.getMetadataEtag(localizedServiceName);
            }
            if (edm == null) {
                edm = accessor.getEdmxMetadataProvider(serviceName);
                etag = accessor.getMetadataEtag(serviceName);
            }
            requestGlobals.setMetadataEtag("W/\"" + etag + "\"");
            if (edm == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERVICE_NOT_FOUND, new Object[]{serviceName});
            }
            return this.createODataSingleProcessorService(edm, new OlingoProcessor(requestGlobals));
        }
        catch (ServiceException e) {
            int httpStatus = e.getErrorStatus().getHttpStatus();
            if (httpStatus >= 500 && httpStatus < 600) {
                logger.error("An unexpected error occurred during servlet processing", (Throwable)e);
            } else {
                logger.debug("An unexpected error occurred during servlet processing", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.error("An unexpected error occurred during servlet processing", (Throwable)e);
        }
        return null;
    }

    private MutablePair<ApplicationService, String> extractServiceInfo(String pathInfo, Map<String, ApplicationService> servicePaths) {
        String servicePath;
        ApplicationService service;
        if (pathInfo.trim().isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_FOUND, new Object[0]);
        }
        String path = StringUtils.trim((String)pathInfo.trim(), (char)'/');
        Optional<String> servicePathKey = servicePaths.keySet().stream().sorted((a, b) -> -1 * Integer.compare(a.length(), b.length())).filter(p -> path.startsWith((String)p)).findFirst();
        if (servicePathKey.isPresent() && (service = servicePaths.get(servicePath = servicePathKey.get())) != null) {
            return MutablePair.of((Object)service, (Object)servicePath);
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERVICE_NOT_FOUND, new Object[]{path});
    }

    public <T extends ODataCallback> T getCallback(Class<T> callbackInterface) {
        return (T)(callbackInterface.isAssignableFrom(ErrorCallback.class) ? new ErrorCallback() : super.getCallback(callbackInterface));
    }
}

