/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2;

import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.adapter.odata.v2.CdsODataV2Servlet;
import com.sap.cds.feature.config.Properties;
import com.sap.cds.reflect.CdsAction;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsFunction;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ODataUtils;
import com.sap.cds.services.utils.path.CdsResourcePath;
import com.sap.cds.services.utils.path.CdsServicePath;
import com.sap.cds.services.utils.path.UrlPathUtil;
import com.sap.cds.services.utils.path.UrlResourcePathBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.servlet.Servlet;

public class CdsODataV2ServletFactory
implements ServletAdapterFactory {
    public static final String PROTOCOL_KEY = "odata-v2";

    public boolean isEnabled() {
        return Properties.getCds().getOdataV2().getEndpoint().isEnabled();
    }

    public Servlet createAdapter(CdsRuntime runtime) {
        return new CdsODataV2Servlet(runtime);
    }

    public String getBasePath() {
        return UrlPathUtil.normalizeBasePath((String)Properties.getCds().getOdataV2().getEndpoint().getPath());
    }

    public String[] getMappings(CdsRuntime runtime) {
        Stream cdsServicePaths = CdsServicePath.servicePaths((ServiceCatalog)runtime.getServiceCatalog(), (String)PROTOCOL_KEY);
        return (String[])cdsServicePaths.map(servicePath -> UrlResourcePathBuilder.path((String[])new String[]{this.getBasePath(), servicePath.getPath()}).recursive().build().getPath()).toArray(String[]::new);
    }

    public UrlResourcePath getServletPath(CdsRuntime runtime) {
        boolean openMetadataEndpoint = Properties.getCds().getSecurity().isOpenMetadataEndpoints();
        Stream cdsServicePaths = CdsServicePath.servicePaths((ServiceCatalog)runtime.getServiceCatalog(), (String)PROTOCOL_KEY);
        return UrlResourcePathBuilder.path((String[])new String[]{this.getBasePath()}).recursive().subPaths(cdsServicePaths.flatMap(cdsServicePath -> {
            boolean servicePublic = cdsServicePath.isPublic() && !cdsServicePath.subPaths().anyMatch(p -> !p.isPublic());
            return Stream.of(UrlResourcePathBuilder.path((String[])new String[]{cdsServicePath.getPath(), "$metadata"}).isPublic(openMetadataEndpoint || cdsServicePath.isPublic()).build(), UrlResourcePathBuilder.path((String[])new String[]{cdsServicePath.getPath(), "$batch"}).isPublic(servicePublic).build(), UrlResourcePathBuilder.path((String[])new String[]{cdsServicePath.getPath()}).isPublic(cdsServicePath.isPublic()).subPaths(cdsServicePath.subPaths().flatMap(cdsSubPath -> {
                if (cdsSubPath.hasType(CdsEntity.class)) {
                    return CdsODataV2ServletFactory.getEntitySubPaths(cdsServicePath, cdsSubPath).stream();
                }
                return CdsODataV2ServletFactory.actionOrFunction(cdsSubPath, cdsSubPath.getPath(), cdsServicePath.isPublic());
            })).build(), UrlResourcePathBuilder.path((String[])new String[]{cdsServicePath.getPath(), "/"}).isPublic(cdsServicePath.isPublic()).build());
        })).build();
    }

    private static List<UrlResourcePath> getEntitySubPaths(CdsResourcePath cdsServicePath, CdsResourcePath cdsSubPath) {
        boolean isPublic = cdsServicePath.isPublic() && cdsSubPath.isPublic();
        ArrayList<UrlResourcePath> result = new ArrayList<UrlResourcePath>();
        result.add(UrlResourcePathBuilder.path((String[])new String[]{ODataUtils.toODataName((String)cdsSubPath.getPath())}).recursive().isPublic(isPublic).publicEvents(cdsSubPath.publicEvents().map(UrlPathUtil::cdsEvent2HttpMethod).filter(Objects::nonNull)).build());
        result.add(UrlResourcePathBuilder.path((String[])new String[]{cdsSubPath.getPath() + "(*)"}).recursive().isPublic(isPublic).publicEvents(cdsSubPath.publicEvents().map(UrlPathUtil::cdsEvent2HttpMethod).filter(Objects::nonNull)).build());
        cdsSubPath.subPaths().forEach(p -> {
            String actionOrFunctionPath = cdsSubPath.getPath() + "_" + p.getPath();
            CdsODataV2ServletFactory.actionOrFunction(p, actionOrFunctionPath, isPublic).forEach(urlPath -> result.add((UrlResourcePath)urlPath));
        });
        return result;
    }

    private static Stream<UrlResourcePath> actionOrFunction(CdsResourcePath p, String actionOrFunctionPath, boolean parentIsPublic) {
        if (p.hasType(CdsAction.class) || p.hasType(CdsFunction.class)) {
            String httpMethod = p.hasType(CdsAction.class) ? UrlPathUtil.HttpMethod.POST.name() : UrlPathUtil.HttpMethod.GET.name();
            return Stream.of(UrlResourcePathBuilder.path((String[])new String[]{actionOrFunctionPath}).isPublic(false).publicEvents(parentIsPublic && p.isPublic() ? Stream.of(httpMethod) : Stream.empty()).build(), UrlResourcePathBuilder.path((String[])new String[]{actionOrFunctionPath + "(*)"}).isPublic(false).publicEvents(parentIsPublic && p.isPublic() ? Stream.of(httpMethod) : Stream.empty()).build());
        }
        return Stream.empty();
    }
}

