/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.metadata.mtx;

import com.google.common.hash.Hashing;
import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.adapter.odata.v2.metadata.mtx.DefaultEdmxProviderAccessor;
import com.sap.cds.adapter.odata.v2.metadata.mtx.MtxEdmxProviderAccessor;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.mtx.MtxUtils;
import java.io.ByteArrayInputStream;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEdmxProviderAccessor {
    private static Logger log = LoggerFactory.getLogger(AbstractEdmxProviderAccessor.class);
    protected static final String XML = ".xml";
    private static final AbstractEdmxProviderAccessor defaultInstance = new DefaultEdmxProviderAccessor();
    private static AbstractEdmxProviderAccessor instance;

    public static void initialize(CdsRuntime runtime) {
        if (MtxUtils.mtxEnabled()) {
            instance = new MtxEdmxProviderAccessor(runtime);
            log.info("Initialized MTX EDMX V2 Provider");
        } else {
            instance = defaultInstance;
            log.info("Initialized Default EDMX V2 Provider");
        }
    }

    public static AbstractEdmxProviderAccessor getInstance() {
        if (defaultInstance == instance || CdsRequestGlobals.currentContext().getUserInfo().getTenant() == null) {
            return defaultInstance;
        }
        return instance;
    }

    public ODataV2EdmProvider getEdmxMetadataProvider(String serviceName) {
        String name = this.getServiceByNamespace(serviceName);
        if (name == null) {
            name = serviceName;
        }
        return this.getMetadataInfo(name).getEdmxMetadataProvider();
    }

    public String getMetadataEtag(String serviceName) {
        String name = this.getServiceByNamespace(serviceName);
        if (name == null) {
            name = serviceName;
        }
        return this.getMetadataInfo(name).getEtag();
    }

    protected abstract MetadataInfo getMetadataInfo(String var1);

    protected abstract void storeAlias(String var1, String var2);

    protected abstract void storeNameSpace(String var1, String var2);

    protected abstract String getAlias(String var1);

    protected abstract String getNameSpace(String var1);

    protected ODataV2EdmProvider loadMetadataFiles(String serviceName, byte[] edmxBytes) {
        if (edmxBytes == null || edmxBytes.length == 0) {
            return null;
        }
        log.info("Loading OData V2 metadata for service '{}'", (Object)serviceName);
        try {
            ODataV2EdmProvider edmxProvider = new ODataV2EdmProvider(new ByteArrayInputStream(edmxBytes));
            this.storeAliasNamespace(edmxProvider, serviceName);
            return edmxProvider;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("The provided bytes don't contain OData V2 metadata", e);
        }
    }

    protected String calculateMetadataEtag(byte[] edmxBytes) {
        if (edmxBytes == null || edmxBytes.length == 0) {
            return null;
        }
        return Hashing.sha256().hashBytes(edmxBytes).toString();
    }

    private void storeAliasNamespace(ODataV2EdmProvider edmxMetadataProvider, String serviceName) throws ODataException {
        edmxMetadataProvider.getSchemas().forEach(schema -> {
            this.registerSchemaNamespace(schema.getNamespace(), serviceName);
            this.registerSchemaAlias(schema.getAlias(), serviceName);
        });
    }

    private void registerSchemaAlias(String alias, String serviceName) {
        if (alias != null) {
            this.storeAlias(alias, serviceName);
        }
    }

    private void registerSchemaNamespace(String namespace, String serviceName) {
        if (namespace != null) {
            this.storeNameSpace(namespace, serviceName);
        }
    }

    private String getServiceByNamespace(String namespace) {
        String alias = this.getAlias(namespace);
        if (alias != null) {
            return alias;
        }
        return this.getNameSpace(namespace);
    }
}

