/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.metadata.mtx;

import com.google.common.io.ByteStreams;
import com.sap.cds.adapter.odata.v2.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.adapter.odata.v2.metadata.mtx.AbstractEdmxProviderAccessor;
import com.sap.cds.feature.config.Properties;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEdmxProviderAccessor
extends AbstractEdmxProviderAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultEdmxProviderAccessor.class);
    private String basePath = "edmx";
    private final Map<String, MetadataInfo> metadataInfoMap = new ConcurrentHashMap<String, MetadataInfo>();
    private final Map<String, String> aliasMap = new ConcurrentHashMap<String, String>();
    private final Map<String, String> namespaceMap = new ConcurrentHashMap<String, String>();

    public DefaultEdmxProviderAccessor() {
        String configBasePath = Properties.getCds().getOdataV2().getEdmxPath();
        if (this.getClass().getClassLoader().getResource(configBasePath) != null) {
            this.basePath = configBasePath;
        }
    }

    @Override
    protected MetadataInfo getMetadataInfo(String serviceName) {
        return this.metadataInfoMap.computeIfAbsent(serviceName, key -> {
            ODataV2EdmProvider provider = null;
            String etag = null;
            String resourcePathToEdmx = this.basePath + "/" + serviceName + ".xml";
            InputStream edmxStream = this.getClass().getClassLoader().getResourceAsStream(resourcePathToEdmx);
            if (edmxStream != null) {
                try {
                    byte[] edmxBytes = ByteStreams.toByteArray((InputStream)edmxStream);
                    provider = this.loadMetadataFiles(serviceName, edmxBytes);
                    etag = this.calculateMetadataEtag(edmxBytes);
                }
                catch (Exception e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA_V2, new Object[]{resourcePathToEdmx, e});
                }
                finally {
                    try {
                        edmxStream.close();
                    }
                    catch (IOException e) {
                        log.warn("Failed to close edmx input stream", (Throwable)e);
                    }
                }
            }
            return new MetadataInfo(serviceName, serviceName, provider, etag);
        });
    }

    @Override
    protected void storeAlias(String key, String value) {
        this.aliasMap.put(key, value);
    }

    @Override
    protected void storeNameSpace(String key, String value) {
        this.namespaceMap.put(key, value);
    }

    @Override
    protected String getAlias(String key) {
        return this.aliasMap.get(key);
    }

    @Override
    protected String getNameSpace(String key) {
        return this.namespaceMap.get(key);
    }
}

