/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.metadata.mtx;

import com.sap.cds.adapter.odata.v2.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.adapter.odata.v2.metadata.mtx.AbstractEdmxProviderAccessor;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.mtx.MtxUtils;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtxEdmxProviderAccessor
extends AbstractEdmxProviderAccessor {
    private static Logger log = LoggerFactory.getLogger(MtxEdmxProviderAccessor.class);
    private final MetaDataAccessor<MetadataInfo> accessor;
    private final CdsRuntime runtime;
    private final TenantAwareCache<Map<String, String>, CdsModel> aliasCache;
    private final TenantAwareCache<Map<String, String>, CdsModel> namespaceCache;

    public MtxEdmxProviderAccessor(CdsRuntime runtime) {
        this.runtime = runtime;
        this.aliasCache = TenantAwareCache.create(() -> new ConcurrentHashMap(), (CdsRuntime)runtime);
        this.namespaceCache = TenantAwareCache.create(() -> new ConcurrentHashMap(), (CdsRuntime)runtime);
        SidecarAccess access = MtxUtils.getSidecarAccess();
        CacheParams cacheParams = MtxUtils.getCacheParams();
        this.accessor = new MetaDataAccessorImpl(access, cacheParams, (edmx, service) -> {
            ODataV2EdmProvider edmProvider;
            byte[] edmxBytes = edmx.getBytes(StandardCharsets.UTF_8);
            try {
                edmProvider = this.loadMetadataFiles(service, edmxBytes);
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA_V2_MTX, new Object[]{service, e});
            }
            String etag = this.calculateMetadataEtag(edmxBytes);
            return new MetadataInfo(service, service, edmProvider, etag);
        }, null);
    }

    @Override
    protected MetadataInfo getMetadataInfo(String serviceName) {
        Locale locale = RequestContext.getCurrent((CdsRuntime)this.runtime).getParameterInfo().getLocale();
        String localeString = locale != null ? locale.getLanguage() : Locale.ENGLISH.getLanguage();
        log.debug("Retrieving model for service name '{}' and locale '{}'", (Object)serviceName, (Object)(localeString != null ? localeString : "<none>"));
        try {
            return (MetadataInfo)this.accessor.getEdmx(RequestContext.getCurrent((CdsRuntime)this.runtime).getUserInfo().getTenant(), serviceName, localeString);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EDMX_READ_FAILED, new Object[]{serviceName, t});
        }
    }

    @Override
    protected void storeAlias(String key, String value) {
        ((Map)this.aliasCache.findOrCreate()).put(key, value);
    }

    @Override
    protected void storeNameSpace(String key, String value) {
        ((Map)this.namespaceCache.findOrCreate()).put(key, value);
    }

    @Override
    protected String getAlias(String key) {
        return (String)((Map)this.aliasCache.findOrCreate()).get(key);
    }

    @Override
    protected String getNameSpace(String key) {
        return (String)((Map)this.namespaceCache.findOrCreate()).get(key);
    }
}

