/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.query;

import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.query.ExpressionToCqnVisitor;
import com.sap.cds.adapter.odata.v2.query.LimitLookup;
import com.sap.cds.adapter.odata.v2.query.NextLinkInfo;
import com.sap.cds.adapter.odata.v2.query.expand.ExpandItem;
import com.sap.cds.adapter.odata.v2.utils.ExpandItemTreeBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Expand;
import com.sap.cds.ql.Orderable;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.TenantAwareCache;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.NavigationPropertySegment;
import org.apache.olingo.odata2.api.uri.SelectItem;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.expression.ExceptionVisitExpression;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;

public class SystemQueryLoader {
    private static final TenantAwareCache<LimitLookup, CdsModel> limitLookup = TenantAwareCache.create(() -> CdsRequestGlobals.currentContext().getUserInfo().getTenant(), LimitLookup::new, () -> CdsRequestGlobals.currentContext().getModel());

    private SystemQueryLoader() {
    }

    public static NextLinkInfo applySystemQueryOptions(Select<?> select, UriInfo uriInfo, boolean limit, CdsService service, CdsEntity entity) {
        InlineCount inlineCount;
        NextLinkInfo nextLinkInfo = null;
        select.columns(entity.nonAssociationElements().map(e -> CQL.get((String)e.getName())));
        if (limit) {
            int maxTop;
            int top = Integer.MAX_VALUE;
            int skip = 0;
            if (uriInfo.getTop() != null) {
                top = uriInfo.getTop();
            }
            if (uriInfo.getSkipToken() != null) {
                skip = Integer.parseInt(uriInfo.getSkipToken());
            } else if (uriInfo.getSkip() != null) {
                skip = uriInfo.getSkip();
            }
            boolean serverDrivenPaging = false;
            int defaultTop = ((LimitLookup)limitLookup.findOrCreate()).getDefaultValue(service, entity);
            if (defaultTop > 0 && top == Integer.MAX_VALUE) {
                top = defaultTop;
                serverDrivenPaging = true;
            }
            if ((maxTop = ((LimitLookup)limitLookup.findOrCreate()).getMaxValue(service, entity)) > 0 && top > maxTop) {
                top = maxTop;
                serverDrivenPaging = true;
            }
            if (top < Integer.MAX_VALUE || skip > 0) {
                select.limit((long)top, (long)skip);
                if (serverDrivenPaging) {
                    nextLinkInfo = new NextLinkInfo(top, skip);
                }
            }
        }
        if ((inlineCount = uriInfo.getInlineCount()) == InlineCount.ALLPAGES) {
            select.inlineCount();
        }
        if (uriInfo.getOrderBy() != null) {
            select.orderBy(SystemQueryLoader.convertOrderByOption(uriInfo.getOrderBy()));
        }
        if (uriInfo.getFilter() != null) {
            select.where((CqnPredicate)SystemQueryLoader.convertFilterOption(uriInfo.getFilter()));
        }
        return nextLinkInfo;
    }

    private static List<CqnSortSpecification> convertOrderByOption(OrderByExpression orderByOption) {
        ArrayList<CqnSortSpecification> sortList = new ArrayList<CqnSortSpecification>();
        for (OrderExpression orderByItem : orderByOption.getOrders()) {
            try {
                Orderable orderByElement = (Orderable)orderByItem.getExpression().accept((ExpressionVisitor)new ExpressionToCqnVisitor());
                SortOrder sortOrder = orderByItem.getSortOrder();
                sortList.add(sortOrder == SortOrder.desc ? orderByElement.desc() : orderByElement.asc());
            }
            catch (ODataApplicationException | ExceptionVisitExpression e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ORDERBY_PARSING_FAILED, new Object[]{e});
            }
        }
        return sortList;
    }

    private static Predicate convertFilterOption(FilterExpression filter) {
        try {
            return (Predicate)filter.getExpression().accept((ExpressionVisitor)new ExpressionToCqnVisitor());
        }
        catch (ODataApplicationException | ExceptionVisitExpression e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.FILTER_PARSING_FAILED, new Object[]{e});
        }
    }

    public static void updateSelectColumns(Select<?> select, UriInfo uriInfo, CdsEntity entity) throws EdmException {
        if (uriInfo.getSelect() != null && !uriInfo.getSelect().isEmpty()) {
            select.columns(SystemQueryLoader.reduce(select.items(), SystemQueryLoader.getSelectColumns(uriInfo.getSelect(), entity)));
        }
        if (uriInfo.getExpand() != null && !uriInfo.getExpand().isEmpty()) {
            ExpandItem expandItem = ExpandItemTreeBuilder.buildTree(uriInfo.getExpand(), SystemQueryLoader::getNavigationPropertyName);
            select.columns(SystemQueryLoader.merge(select.items(), SystemQueryLoader.getExpands(expandItem, entity)));
        }
    }

    private static String getNavigationPropertyName(NavigationPropertySegment nps) {
        try {
            return nps.getNavigationProperty().getName();
        }
        catch (EdmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static List<CqnSelectListItem> reduce(List<CqnSelectListItem> columns, List<String> allowedColumns) {
        return columns.stream().filter(i -> i.isValue() && allowedColumns.contains(i.asValue().displayName())).collect(Collectors.toList());
    }

    private static List<String> getSelectColumns(List<SelectItem> selectItems, CdsEntity entity) throws EdmException {
        HashSet<String> items = new HashSet<String>();
        entity.keyElements().map(key -> key.getName()).forEach(items::add);
        for (SelectItem selectItem : selectItems) {
            if (selectItem.isStar()) {
                items.clear();
                entity.nonAssociationElements().map(CdsElement::getName).forEach(items::add);
                break;
            }
            if (selectItem.getProperty() != null) {
                items.add(selectItem.getProperty().getName());
            }
            if (selectItem.getNavigationPropertySegments() == null) continue;
            List navItems = selectItem.getNavigationPropertySegments();
            for (NavigationPropertySegment segment : navItems) {
                if (segment.getNavigationProperty() == null) continue;
                items.add(segment.getNavigationProperty().getName());
            }
        }
        return new ArrayList<String>(items);
    }

    private static List<CqnSelectListItem> getExpands(ExpandItem expandItems, CdsEntity entity) {
        ArrayList<CqnSelectListItem> expands = new ArrayList<CqnSelectListItem>();
        expandItems.forEach((npName, item) -> {
            StructuredType type = CQL.to((String)npName);
            CdsEntity navigationTarget = entity.getTargetOf(npName);
            List<CqnSelectListItem> items = navigationTarget.nonAssociationElements().map(e -> CQL.get((String)e.getName())).collect(Collectors.toList());
            items = SystemQueryLoader.merge(items, SystemQueryLoader.getExpands(item, navigationTarget));
            Expand expand = type.expand(items);
            expands.add((CqnSelectListItem)expand);
        });
        return expands;
    }

    private static List<CqnSelectListItem> merge(List<CqnSelectListItem> columns, List<CqnSelectListItem> additionalColumns) {
        if (additionalColumns.isEmpty()) {
            return columns;
        }
        ArrayList<CqnSelectListItem> items = new ArrayList<CqnSelectListItem>(columns);
        for (CqnSelectListItem newItem : additionalColumns) {
            List<? extends CqnReference.Segment> newSegments = SystemQueryLoader.getSegments(newItem.token());
            items.stream().filter(c -> SystemQueryLoader.isMatching(c, newSegments)).findFirst().ifPresent(items::remove);
            items.add(newItem);
        }
        return items;
    }

    private static List<? extends CqnReference.Segment> getSegments(CqnToken token) {
        CqnValue value;
        if (token instanceof CqnReference) {
            return ((CqnReference)token).segments();
        }
        if (token instanceof Expand) {
            return ((Expand)token).ref().segments();
        }
        if (token instanceof CqnSelectListValue && (value = ((CqnSelectListValue)token).value()).isRef()) {
            return value.asRef().segments();
        }
        return null;
    }

    private static boolean isMatching(CqnSelectListItem c, List<? extends CqnReference.Segment> newSegments) {
        List<? extends CqnReference.Segment> segments = SystemQueryLoader.getSegments(c.token());
        if (segments == null || newSegments == null || segments.size() != newSegments.size()) {
            return false;
        }
        for (int i = 0; i < segments.size(); ++i) {
            CqnReference.Segment segment = segments.get(i);
            CqnReference.Segment newSegment = newSegments.get(i);
            if (!segment.id().equals(newSegment.id())) {
                return false;
            }
            if (!(segment.filter().isPresent() ? !segment.toJson().equals(newSegment.toJson()) : newSegment.filter().isPresent())) continue;
            return false;
        }
        return true;
    }
}

